/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.demo;

import com.netflix.dyno.demo.redis.DynoJedisDemo;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.Message;
import com.netflix.dyno.queues.redis.RedisQueues;
import com.netflix.dyno.queues.redis.v2.QueueBuilder;
import com.netflix.dyno.queues.shard.DynoShardSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.commands.JedisCommands;

public class DynoQueueDemo
extends DynoJedisDemo {
    private static final Logger logger = LoggerFactory.getLogger(DynoQueue.class);

    public DynoQueueDemo(String clusterName, String localRack) {
        super(clusterName, localRack);
    }

    public DynoQueueDemo(String primaryCluster, String shadowCluster, String localRack) {
        super(primaryCluster, shadowCluster, localRack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String clusterName = args[0];
        if (args.length < 2) {
            throw new IllegalArgumentException("Need to pass in cluster-name and version of dyno-queues to run as arguments");
        }
        int version = Integer.parseInt(args[1]);
        DynoQueueDemo demo = new DynoQueueDemo(clusterName, "us-east-1e");
        Properties props = new Properties();
        props.load(DynoQueueDemo.class.getResourceAsStream("/demo.properties"));
        for (String name : props.stringPropertyNames()) {
            System.setProperty(name, props.getProperty(name));
        }
        try {
            demo.initWithRemoteClusterFromEurekaUrl(args[0], 8102, false);
            if (version == 1) {
                demo.runSimpleV1Demo(demo.client);
            } else if (version == 2) {
                demo.runSimpleV2QueueDemo(demo.client);
            }
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            demo.stop();
            logger.info("Done");
        }
    }

    private void runSimpleV1Demo(DynoJedisClient dyno) throws IOException {
        String region = System.getProperty("LOCAL_DATACENTER");
        String localRack = System.getProperty("LOCAL_RACK");
        String prefix = "dynoQueue_";
        DynoShardSupplier ss = new DynoShardSupplier(dyno.getConnPool().getConfiguration().getHostSupplier(), region, localRack);
        RedisQueues queues = new RedisQueues((JedisCommands)dyno, (JedisCommands)dyno, prefix, ss, 50000, 50000);
        ArrayList<Message> payloads = new ArrayList<Message>();
        payloads.add(new Message("id1", "searchable payload123"));
        payloads.add(new Message("id2", "payload 2"));
        payloads.add(new Message("id3", "payload 3"));
        payloads.add(new Message("id4", "payload 4"));
        payloads.add(new Message("id5", "payload 5"));
        payloads.add(new Message("id6", "payload 6"));
        payloads.add(new Message("id7", "payload 7"));
        payloads.add(new Message("id8", "payload 8"));
        payloads.add(new Message("id9", "payload 9"));
        DynoQueue V1Queue = queues.get("simpleQueue");
        V1Queue.clear();
        List pushed_msgs = V1Queue.push(payloads);
        Message msg1 = (Message)payloads.get(0);
        logger.info("Does Message with ID '" + msg1.getId() + "' already exist? -> " + !V1Queue.ensure(msg1));
        logger.info("Does the predicate 'searchable' exist in  the queue? -> " + V1Queue.containsPredicate("searchable"));
        logger.info("Get MSG ID that contains 'searchable' in the queue -> " + V1Queue.getMsgWithPredicate("searchable pay*"));
        ArrayList<Message> specific_pops = new ArrayList<Message>();
        for (int i = 0; i < payloads.size(); ++i) {
            Message popWithMsgId = V1Queue.popWithMsgId(((Message)payloads.get(i)).getId());
            if (popWithMsgId == null) continue;
            specific_pops.add(popWithMsgId);
            break;
        }
        boolean ack_successful = V1Queue.ack(((Message)specific_pops.get(0)).getId());
        assert (ack_successful);
        boolean removed = V1Queue.remove("id9");
        assert (removed);
        List popped_msgs = V1Queue.pop(3, 1000, TimeUnit.MILLISECONDS);
        V1Queue.ack(((Message)popped_msgs.get(0)).getId());
        List peek_all_msgs = V1Queue.unsafePeekAllShards(5);
        for (Message msg : peek_all_msgs) {
            logger.info("Message peeked (ID : payload) -> " + msg.getId() + " : " + msg.getPayload());
        }
        List pop_all_msgs = V1Queue.unsafePopAllShards(2, 1000, TimeUnit.MILLISECONDS);
        for (Message msg : pop_all_msgs) {
            logger.info("Message popped (ID : payload) -> " + msg.getId() + " : " + msg.getPayload());
        }
        V1Queue.clear();
        V1Queue.close();
    }

    private void runSimpleV2QueueDemo(DynoJedisClient dyno) throws IOException {
        String prefix = "dynoQueue_";
        DynoQueue queue = new QueueBuilder().setQueueName("test").setRedisKeyPrefix(prefix).useDynomite(dyno, dyno).setUnackTime(50000).build();
        Message msg = new Message("id1", "message payload");
        queue.push(Arrays.asList(msg));
        int count = 10;
        List polled = queue.pop(count, 1, TimeUnit.SECONDS);
        logger.info(polled.toString());
        queue.ack("id1");
        queue.close();
    }
}

