/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis;

import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.ShardSupplier;
import com.netflix.dyno.queues.redis.RedisDynoQueue;
import com.netflix.dyno.queues.redis.sharding.RoundRobinStrategy;
import com.netflix.dyno.queues.redis.sharding.ShardingStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import redis.clients.jedis.commands.JedisCommands;

public class RedisQueues
implements Closeable {
    private final Clock clock;
    private final JedisCommands quorumConn;
    private final JedisCommands nonQuorumConn;
    private final Set<String> allShards;
    private final String shardName;
    private final String redisKeyPrefix;
    private final int unackTime;
    private final int unackHandlerIntervalInMS;
    private final ConcurrentHashMap<String, DynoQueue> queues;
    private final ShardingStrategy shardingStrategy;

    public RedisQueues(JedisCommands quorumConn, JedisCommands nonQuorumConn, String redisKeyPrefix, ShardSupplier shardSupplier, int unackTime, int unackHandlerIntervalInMS) {
        this(Clock.systemDefaultZone(), quorumConn, nonQuorumConn, redisKeyPrefix, shardSupplier, unackTime, unackHandlerIntervalInMS, new RoundRobinStrategy());
    }

    public RedisQueues(JedisCommands quorumConn, JedisCommands nonQuorumConn, String redisKeyPrefix, ShardSupplier shardSupplier, int unackTime, int unackHandlerIntervalInMS, ShardingStrategy shardingStrategy) {
        this(Clock.systemDefaultZone(), quorumConn, nonQuorumConn, redisKeyPrefix, shardSupplier, unackTime, unackHandlerIntervalInMS, shardingStrategy);
    }

    public RedisQueues(Clock clock, JedisCommands quorumConn, JedisCommands nonQuorumConn, String redisKeyPrefix, ShardSupplier shardSupplier, int unackTime, int unackHandlerIntervalInMS, ShardingStrategy shardingStrategy) {
        this.clock = clock;
        this.quorumConn = quorumConn;
        this.nonQuorumConn = nonQuorumConn;
        this.redisKeyPrefix = redisKeyPrefix;
        this.allShards = shardSupplier.getQueueShards();
        this.shardName = shardSupplier.getCurrentShard();
        this.unackTime = unackTime;
        this.unackHandlerIntervalInMS = unackHandlerIntervalInMS;
        this.queues = new ConcurrentHashMap();
        this.shardingStrategy = shardingStrategy;
    }

    public DynoQueue get(String queueName) {
        String key = queueName.intern();
        return this.queues.computeIfAbsent(key, keyToCompute -> new RedisDynoQueue(this.clock, this.redisKeyPrefix, queueName, this.allShards, this.shardName, this.unackHandlerIntervalInMS, this.shardingStrategy).withUnackTime(this.unackTime).withNonQuorumConn(this.nonQuorumConn).withQuorumConn(this.quorumConn));
    }

    public Collection<DynoQueue> queues() {
        return this.queues.values();
    }

    @Override
    public void close() throws IOException {
        this.queues.values().forEach(queue -> {
            try {
                queue.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getCause());
            }
        });
    }
}

