/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.v2;

import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.Message;
import com.netflix.dyno.queues.redis.v2.RedisPipelineQueue;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class MultiRedisQueue
implements DynoQueue {
    private List<String> shards;
    private String name;
    private Map<String, RedisPipelineQueue> queues = new HashMap<String, RedisPipelineQueue>();
    private RedisPipelineQueue me;
    private AtomicInteger nextShardIndex = new AtomicInteger(0);

    public MultiRedisQueue(String queueName, String shardName, Map<String, RedisPipelineQueue> queues) {
        this.name = queueName;
        this.queues = queues;
        this.me = queues.get(shardName);
        if (this.me == null) {
            throw new IllegalArgumentException("List of shards supplied (" + queues.keySet() + ") does not contain current shard name: " + shardName);
        }
        this.shards = queues.keySet().stream().collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public int getUnackTime() {
        return this.me.getUnackTime();
    }

    public List<String> push(List<Message> messages) {
        int size = this.queues.size();
        int partitionSize = messages.size() / size;
        LinkedList<String> ids = new LinkedList<String>();
        for (int i = 0; i < size - 1; ++i) {
            RedisPipelineQueue queue = this.queues.get(this.getNextShard());
            int start = i * partitionSize;
            int end = start + partitionSize;
            ids.addAll(queue.push(messages.subList(start, end)));
        }
        RedisPipelineQueue queue = this.queues.get(this.getNextShard());
        int start = (size - 1) * partitionSize;
        ids.addAll(queue.push(messages.subList(start, messages.size())));
        return ids;
    }

    public List<Message> pop(int messageCount, int wait, TimeUnit unit) {
        return this.me.pop(messageCount, wait, unit);
    }

    public Message popWithMsgId(String messageId) {
        throw new UnsupportedOperationException();
    }

    public List<Message> peek(int messageCount) {
        return this.me.peek(messageCount);
    }

    public boolean ack(String messageId) {
        for (DynoQueue dynoQueue : this.queues.values()) {
            if (!dynoQueue.ack(messageId)) continue;
            return true;
        }
        return false;
    }

    public void ack(List<Message> messages) {
        Map<String, List<Message>> byShard = messages.stream().collect(Collectors.groupingBy(Message::getShard));
        for (Map.Entry<String, List<Message>> e : byShard.entrySet()) {
            this.queues.get(e.getKey()).ack(e.getValue());
        }
    }

    public boolean setUnackTimeout(String messageId, long timeout) {
        for (DynoQueue dynoQueue : this.queues.values()) {
            if (!dynoQueue.setUnackTimeout(messageId, timeout)) continue;
            return true;
        }
        return false;
    }

    public boolean setTimeout(String messageId, long timeout) {
        for (DynoQueue dynoQueue : this.queues.values()) {
            if (!dynoQueue.setTimeout(messageId, timeout)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(String messageId) {
        for (DynoQueue dynoQueue : this.queues.values()) {
            if (!dynoQueue.remove(messageId)) continue;
            return true;
        }
        return false;
    }

    public boolean ensure(Message message) {
        throw new UnsupportedOperationException();
    }

    public boolean containsPredicate(String predicate) {
        throw new UnsupportedOperationException();
    }

    public String getMsgWithPredicate(String predicate) {
        throw new UnsupportedOperationException();
    }

    public Message get(String messageId) {
        for (DynoQueue dynoQueue : this.queues.values()) {
            Message msg = dynoQueue.get(messageId);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    public long size() {
        long size = 0L;
        for (DynoQueue dynoQueue : this.queues.values()) {
            size += dynoQueue.size();
        }
        return size;
    }

    public Map<String, Map<String, Long>> shardSizes() {
        HashMap<String, Map<String, Long>> sizes = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, RedisPipelineQueue> e : this.queues.entrySet()) {
            sizes.put(e.getKey(), e.getValue().shardSizes().get(e.getKey()));
        }
        return sizes;
    }

    public void clear() {
        for (DynoQueue dynoQueue : this.queues.values()) {
            dynoQueue.clear();
        }
    }

    public void close() throws IOException {
        for (RedisPipelineQueue queue : this.queues.values()) {
            queue.close();
        }
    }

    public void processUnacks() {
        for (RedisPipelineQueue queue : this.queues.values()) {
            queue.processUnacks();
        }
    }

    private String getNextShard() {
        int indx = this.nextShardIndex.incrementAndGet();
        if (indx >= this.shards.size()) {
            this.nextShardIndex.set(0);
            indx = 0;
        }
        String s = this.shards.get(indx);
        return s;
    }

    public List<Message> unsafePeekAllShards(int messageCount) {
        throw new UnsupportedOperationException();
    }

    public List<Message> unsafePopAllShards(int messageCount, int wait, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }
}

