/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.v2;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostBuilder;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.impl.utils.ConfigUtils;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.ShardSupplier;
import com.netflix.dyno.queues.redis.conn.DynoClientProxy;
import com.netflix.dyno.queues.redis.conn.JedisProxy;
import com.netflix.dyno.queues.redis.conn.RedisConnection;
import com.netflix.dyno.queues.redis.v2.MultiRedisQueue;
import com.netflix.dyno.queues.redis.v2.RedisPipelineQueue;
import com.netflix.dyno.queues.shard.DynoShardSupplier;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class QueueBuilder {
    private Clock clock;
    private String queueName;
    private String redisKeyPrefix;
    private int unackTime;
    private String currentShard;
    private ShardSupplier shardSupplier;
    private HostSupplier hs;
    private EurekaClient eurekaClient;
    private String applicationName;
    private Collection<Host> hosts;
    private JedisPoolConfig redisPoolConfig;
    private DynoJedisClient dynoQuorumClient;
    private DynoJedisClient dynoNonQuorumClient;

    public QueueBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public QueueBuilder setApplicationName(String appName) {
        this.applicationName = appName;
        return this;
    }

    public QueueBuilder setEurekaClient(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
        return this;
    }

    public QueueBuilder setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public QueueBuilder setRedisKeyPrefix(String redisKeyPrefix) {
        this.redisKeyPrefix = redisKeyPrefix;
        return this;
    }

    public QueueBuilder useNonDynomiteRedis(JedisPoolConfig redisPoolConfig, List<Host> redisHosts) {
        this.redisPoolConfig = redisPoolConfig;
        this.hosts = redisHosts;
        return this;
    }

    public QueueBuilder useDynomite(DynoJedisClient dynoQuorumClient, DynoJedisClient dynoNonQuorumClient) {
        this.dynoQuorumClient = dynoQuorumClient;
        this.dynoNonQuorumClient = dynoNonQuorumClient;
        this.hs = dynoQuorumClient.getConnPool().getConfiguration().getHostSupplier();
        return this;
    }

    public QueueBuilder setUnackTime(int unackTime) {
        this.unackTime = unackTime;
        return this;
    }

    public QueueBuilder setCurrentShard(String currentShard) {
        this.currentShard = currentShard;
        return this;
    }

    public QueueBuilder setShardSupplier(ShardSupplier shardSupplier) {
        this.shardSupplier = shardSupplier;
        return this;
    }

    public DynoQueue build() {
        boolean useDynomiteCluster;
        boolean bl = useDynomiteCluster = this.dynoQuorumClient != null;
        if (useDynomiteCluster) {
            if (this.hs == null) {
                this.hs = this.dynoQuorumClient.getConnPool().getConfiguration().getHostSupplier();
            }
            this.hosts = this.hs.getHosts();
        }
        if (this.shardSupplier == null) {
            String region = ConfigUtils.getDataCenter();
            String az = ConfigUtils.getLocalZone();
            this.shardSupplier = new DynoShardSupplier(this.hs, region, az);
        }
        if (this.currentShard == null) {
            this.currentShard = this.shardSupplier.getCurrentShard();
        }
        if (this.clock == null) {
            this.clock = Clock.systemDefaultZone();
        }
        HashMap<String, Host> shardMap = new HashMap<String, Host>();
        for (Host host : this.hosts) {
            String shard = this.shardSupplier.getShardForHost(host);
            shardMap.put(shard, host);
        }
        HashMap<String, RedisPipelineQueue> queues = new HashMap<String, RedisPipelineQueue>();
        for (String queueShard : shardMap.keySet()) {
            Host host = (Host)shardMap.get(queueShard);
            String hostAddress = host.getIpAddress();
            if (hostAddress == null || "".equals(hostAddress)) {
                hostAddress = host.getHostName();
            }
            RedisConnection redisConn = null;
            RedisConnection redisConnRead = null;
            if (useDynomiteCluster) {
                redisConn = new DynoClientProxy(this.dynoQuorumClient);
                if (this.dynoNonQuorumClient == null) {
                    this.dynoNonQuorumClient = this.dynoQuorumClient;
                }
                redisConnRead = new DynoClientProxy(this.dynoNonQuorumClient);
            } else {
                JedisPool pool = new JedisPool((GenericObjectPoolConfig)this.redisPoolConfig, hostAddress, host.getPort(), 0);
                redisConn = new JedisProxy(pool);
                redisConnRead = new JedisProxy(pool);
            }
            RedisPipelineQueue q = new RedisPipelineQueue(this.clock, this.redisKeyPrefix, this.queueName, queueShard, this.unackTime, this.unackTime, redisConn);
            q.setNonQuorumPool(redisConnRead);
            queues.put(queueShard, q);
        }
        if (queues.size() == 1) {
            return (DynoQueue)queues.values().iterator().next();
        }
        MultiRedisQueue multiRedisQueue = new MultiRedisQueue(this.queueName, this.currentShard, queues);
        return multiRedisQueue;
    }

    private HostSupplier getHostSupplierFromEureka(String applicationName) {
        return () -> {
            Application app = this.eurekaClient.getApplication(applicationName);
            ArrayList hosts = new ArrayList();
            if (app == null) {
                return hosts;
            }
            List ins = app.getInstances();
            if (ins == null || ins.isEmpty()) {
                return hosts;
            }
            hosts = Lists.newArrayList((Iterable)Collections2.transform((Collection)ins, info -> {
                Host.Status status = info.getStatus() == InstanceInfo.InstanceStatus.UP ? Host.Status.Up : Host.Status.Down;
                String rack = null;
                if (info.getDataCenterInfo() instanceof AmazonInfo) {
                    AmazonInfo amazonInfo = (AmazonInfo)info.getDataCenterInfo();
                    rack = amazonInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
                }
                Host host = new HostBuilder().setHostname(info.getHostName()).setIpAddress(info.getIPAddr()).setRack(rack).setStatus(status).createHost();
                return host;
            }));
            return hosts;
        };
    }
}

