/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example.datafetcher;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsEnableDataFetcherInstrumentation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.example.context.MyContext;
import graphql.GraphQLException;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.springframework.web.bind.annotation.RequestHeader;

@DgsComponent
public class HelloDataFetcher {
    @DgsQuery
    @DgsEnableDataFetcherInstrumentation(value=false)
    public String hello(@InputArgument String name, DgsDataFetchingEnvironment dfe) {
        if (name == null) {
            name = "Stranger";
        }
        Map extensions = DgsContext.getRequestData((DataFetchingEnvironment)dfe).getExtensions();
        System.out.println(extensions);
        return "hello, " + name + "!";
    }

    @DgsQuery
    public String helloWithHeaders(@InputArgument String name, @RequestHeader(value="Authorization") String authorization) {
        return "hello, " + authorization + "!";
    }

    @DgsData(parentType="Query", field="messageFromBatchLoader")
    public CompletableFuture<String> getMessage(DataFetchingEnvironment env) {
        DataLoader dataLoader = env.getDataLoader("messages");
        return dataLoader.load((Object)"a");
    }

    @DgsData(parentType="Query", field="withContext")
    public String withContext(DataFetchingEnvironment dfe) {
        MyContext customContext = (MyContext)DgsContext.getCustomContext((DataFetchingEnvironment)dfe);
        return customContext.getCustomState();
    }

    @DgsData(parentType="Query", field="withDataLoaderContext")
    @DgsEnableDataFetcherInstrumentation
    public CompletableFuture<String> withDataLoaderContext(DataFetchingEnvironment dfe) {
        DataLoader exampleLoaderWithContext = dfe.getDataLoader("exampleLoaderWithContext");
        return exampleLoaderWithContext.load((Object)"A");
    }

    @DgsData(parentType="Query", field="withGraphqlException")
    public String withGraphqlException() {
        throw new GraphQLException("that's not going to work!");
    }

    @DgsData(parentType="Query", field="withRuntimeException")
    public String withRuntimeException() {
        throw new RuntimeException("That's broken!");
    }
}

