/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication(scanBasePackages={"com.netflix.graphql.dgs.example.shared", "com.netflix.graphql.dgs.example"})
public class ExampleApp {
    public static void main(String[] args) {
        SpringApplication.run(ExampleApp.class, (String[])args);
    }

    @Configuration
    static class PreparsedDocumentProviderConfig {
        private final Cache<String, PreparsedDocumentEntry> cache = Caffeine.newBuilder().maximumSize(250L).expireAfterAccess(5L, TimeUnit.MINUTES).recordStats().build();

        PreparsedDocumentProviderConfig() {
        }

        @Bean
        public PreparsedDocumentProvider preparsedDocumentProvider() {
            return (executionInput, parseAndValidateFunction) -> {
                Function<String, PreparsedDocumentEntry> mapCompute = key -> (PreparsedDocumentEntry)parseAndValidateFunction.apply(executionInput);
                return (PreparsedDocumentEntry)this.cache.get((Object)executionInput.getQuery(), mapCompute);
            };
        }
    }
}

