/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example.datafetcher;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.InputArgument;
import graphql.schema.DataFetchingEnvironment;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

@DgsComponent
public class FileUploadMutation {
    private static final Logger log = LoggerFactory.getLogger(FileUploadMutation.class);

    @DgsData(parentType="Mutation", field="uploadFile")
    public boolean uploadFile(@InputArgument FileUploadInput input, DataFetchingEnvironment dfe) {
        List<MultipartFile> parts = input.getFiles();
        for (int i = 0; i < parts.size(); ++i) {
            try {
                String content = new String(parts.get(i).getBytes());
                log.debug("File upload contents are\n{}\n", (Object)content);
                continue;
            }
            catch (IOException e) {
                log.error("Failed to upload file[{}]!", (Object)i, (Object)e);
                e.printStackTrace();
            }
        }
        return !parts.isEmpty();
    }

    static class FileUploadInput {
        private String description;
        private List<MultipartFile> files;

        FileUploadInput() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<MultipartFile> getFiles() {
            return this.files;
        }

        public void setFiles(List<MultipartFile> file) {
            this.files = file;
        }
    }
}

