/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example.shared.instrumentation;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class ExampleInstrumentationDependingOnContextContributor
extends SimplePerformantInstrumentation {
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        GraphQLContext context = parameters.getExecutionInput().getGraphQLContext();
        final String contextContributorIndicator = (String)context.get((Object)"contributorEnabled");
        if (contextContributorIndicator != null) {
            return new InstrumentationState(){

                public String toString() {
                    return contextContributorIndicator;
                }
            };
        }
        return super.createState(parameters);
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (state == null) {
            return super.instrumentExecutionResult(executionResult, parameters, state);
        }
        return CompletableFuture.completedFuture(ExecutionResultImpl.newExecutionResult().from(executionResult).addExtension("contributorEnabled", (Object)state.toString()).build());
    }
}

