/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example.datafetcher;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsEnableDataFetcherInstrumentation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.example.shared.context.MyContext;
import com.netflix.graphql.dgs.example.shared.types.Message;
import graphql.GraphQLException;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;

@DgsComponent
public class HelloDataFetcher {
    @DgsQuery
    @DgsEnableDataFetcherInstrumentation(value=false)
    public String hello(@InputArgument String name) {
        if (name == null) {
            name = "Stranger";
        }
        return "hello, " + name + "!";
    }

    @DgsData(parentType="Query", field="messageFromBatchLoader")
    public CompletableFuture<String> getMessage(DataFetchingEnvironment env) {
        DataLoader dataLoader = env.getDataLoader("messages");
        return dataLoader.load((Object)"a");
    }

    @DgsData(parentType="Query", field="messageFromBatchLoaderWithScheduledDispatch")
    public CompletableFuture<String> getMessageScheduled(DataFetchingEnvironment env) {
        DataLoader dataLoader = env.getDataLoader("messagesWithScheduledDispatch");
        CompletableFuture res = dataLoader.load((Object)"a");
        return res;
    }

    @DgsData(parentType="Query", field="messagesWithExceptionFromBatchLoader")
    public CompletableFuture<List<Message>> getMessagesWithException(DgsDataFetchingEnvironment env) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("A"));
        messages.add(new Message("B"));
        messages.add(new Message("C"));
        return CompletableFuture.completedFuture(messages);
    }

    @DgsData(parentType="Message", field="info")
    public CompletableFuture<String> getMessageWithException(DgsDataFetchingEnvironment env) {
        Message msg = (Message)env.getSource();
        DataLoader dataLoader = env.getDataLoader("messagesDataLoaderWithException");
        return dataLoader.load((Object)msg.getInfo());
    }

    @DgsData(parentType="Query", field="withContext")
    public String withContext(DataFetchingEnvironment dfe) {
        MyContext customContext = (MyContext)DgsContext.getCustomContext((DataFetchingEnvironment)dfe);
        return customContext.getCustomState();
    }

    @DgsData(parentType="Query", field="withDataLoaderContext")
    @DgsEnableDataFetcherInstrumentation
    public CompletableFuture<String> withDataLoaderContext(DataFetchingEnvironment dfe) {
        DataLoader exampleLoaderWithContext = dfe.getDataLoader("exampleLoaderWithContext");
        return exampleLoaderWithContext.load((Object)"A");
    }

    @DgsData(parentType="Query", field="withDataLoaderGraphQLContext")
    @DgsEnableDataFetcherInstrumentation
    public CompletableFuture<String> withDataLoaderGraphQLContext(DataFetchingEnvironment dfe) {
        DataLoader exampleLoaderWithContext = dfe.getDataLoader("exampleLoaderWithGraphQLContext");
        return exampleLoaderWithContext.load((Object)"contributorEnabled");
    }

    @DgsData(parentType="Query", field="withGraphqlException")
    public String withGraphqlException() {
        throw new GraphQLException("that's not going to work!");
    }

    @DgsData(parentType="Query", field="withRuntimeException")
    public String withRuntimeException() {
        throw new RuntimeException("That's broken!");
    }

    @DgsData(parentType="Query", field="withPagination")
    public Connection<Message> withPagination(DataFetchingEnvironment env) {
        return new SimpleListConnection(Collections.singletonList(new Message("This is a generated connection"))).get(env);
    }
}

