/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.example.shared.dataLoader;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDispatchPredicate;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import org.dataloader.registries.DispatchPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DgsDataLoader(name="messagesWithScheduledDispatch")
public class MessageDataLoaderWithDispatchPredicate
implements BatchLoader<String, String> {
    private Logger logger = LoggerFactory.getLogger(MessageDataLoaderWithDispatchPredicate.class);
    @DgsDispatchPredicate
    DispatchPredicate pred = DispatchPredicate.dispatchIfLongerThan((Duration)Duration.ofSeconds(2L));

    public CompletionStage<List<String>> load(List<String> keys) {
        return CompletableFuture.supplyAsync(() -> keys.stream().map(key -> "hello, " + key + "!").collect(Collectors.toList()));
    }
}

