/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphqlErrorBuilder;
import graphql.schema.GraphQLSchema;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JT\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0016\b\u0001\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "(Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;Lcom/netflix/graphql/dgs/DgsQueryExecutor;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "graphql", "Lorg/springframework/http/ResponseEntity;", "", "body", "fileParams", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "headers", "Lorg/springframework/http/HttpHeaders;", "schema", "graphql-dgs-spring-webmvc"})
public final class DgsRestController {
    @NotNull
    private final Logger logger;
    private final DgsSchemaProvider schemaProvider;
    private final DgsQueryExecutor dgsQueryExecutor;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/graphql"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<String> graphql(@RequestBody @Nullable String body, @RequestParam @Nullable Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @Nullable String operation, @RequestParam(name="map") @Nullable String mapParam, @RequestHeader @NotNull HttpHeaders headers) {
        String string;
        Object opName;
        Object it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.logger.debug("Starting /graphql handling");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        Map inputQuery = null;
        Map queryVariables = null;
        Map extensions = null;
        if (body != null) {
            Map map;
            Map map2;
            this.logger.debug("Reading input value: '{}'", (Object)body);
            try {
                String string2 = body;
                boolean bl2 = false;
                bl = false;
                it = string2;
                boolean bl3 = false;
                ObjectMapper $this$readValue$iv = mapper;
                boolean $i$f$readValue = false;
                String string3 = it;
                ObjectMapper objectMapper = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
                inputQuery = (Map)objectMapper.readValue(string3, typeReference);
            }
            catch (JsonParseException ex) {
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                String string4 = ex.getMessage();
                if (string4 == null) {
                    string4 = "Error parsing query - no details found in the error message";
                }
                ResponseEntity responseEntity = bodyBuilder.body((Object)string4);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026nd in the error message\")");
                return responseEntity;
            }
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                map2 = (Map)v;
            } else {
                map2 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            this.logger.debug("Parsed variables: {}", (Object)queryVariables);
        } else if (fileParams != null && mapParam != null && operation != null) {
            Map fileMapInput;
            Map map;
            Map map3;
            String ex = operation;
            boolean bl4 = false;
            bl = false;
            String it22 = ex;
            boolean bl5 = false;
            ObjectMapper $this$readValue$iv = mapper;
            boolean $i$f$readValue = false;
            String string5 = it22;
            Object object = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef22 = false;
            TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
            inputQuery = (Map)object.readValue(string5, typeReference);
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map3 = (Map)v;
            } else {
                map3 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            String string6 = mapParam;
            bl = false;
            boolean it22 = false;
            String it3 = string6;
            boolean $i$a$-let-DgsRestController$graphql$fileMapInput$22 = false;
            ObjectMapper $this$readValue$iv2 = mapper;
            boolean $i$f$readValue2 = false;
            object = it3;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv2;
            boolean $i$f$jacksonTypeRef = false;
            Object object2 = (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){};
            Map $this$forEach$iv = fileMapInput = (Map)$i$f$jacksonTypeRef22.readValue((String)object, object2);
            boolean $i$f$forEach = false;
            it = $this$forEach$iv;
            boolean bl6 = false;
            Iterator $i$a$-let-DgsRestController$graphql$fileMapInput$22 = it.entrySet().iterator();
            while ($i$a$-let-DgsRestController$graphql$fileMapInput$22.hasNext()) {
                void fileKey;
                Map.Entry element$iv;
                Map.Entry $dstr$fileKey$objectPaths = element$iv = $i$a$-let-DgsRestController$graphql$fileMapInput$22.next();
                boolean bl7 = false;
                $i$f$jacksonTypeRef22 = $dstr$fileKey$objectPaths;
                $i$f$jacksonTypeRef = false;
                object2 = (String)$i$f$jacksonTypeRef22.getKey();
                $i$f$jacksonTypeRef22 = $dstr$fileKey$objectPaths;
                $i$f$jacksonTypeRef = false;
                List objectPaths = (List)$i$f$jacksonTypeRef22.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl8 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, queryVariables, file);
                }
            }
        } else {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - no request body was provided");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026quest body was provided\")");
            return responseEntity;
        }
        Object v = opName = inputQuery.get("operationName");
        if (!(v != null ? v instanceof String : true)) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - operationName must be a String");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026onName must be a String\")");
            return responseEntity;
        }
        String gqlOperationName = (String)opName;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, inputQuery, queryVariables, extensions, headers, gqlOperationName){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ Map $inputQuery;
            final /* synthetic */ Map $queryVariables;
            final /* synthetic */ Map $extensions;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ String $gqlOperationName;

            @NotNull
            public final ExecutionResult invoke() {
                V v = this.$inputQuery.get("query");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return DgsRestController.access$getDgsQueryExecutor$p(this.this$0).execute((String)v, this.$queryVariables, this.$extensions, this.$headers, this.$gqlOperationName);
            }
            {
                this.this$0 = dgsRestController;
                this.$inputQuery = map;
                this.$queryVariables = map2;
                this.$extensions = map3;
                this.$headers = httpHeaders;
                this.$gqlOperationName = string;
                super(0);
            }
        }, this.logger, "Executed query in {}ms");
        this.logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        try {
            string = (String)TimeTracer.INSTANCE.logTime((Function0)new Function0<String>(mapper, executionResult2){
                final /* synthetic */ ObjectMapper $mapper;
                final /* synthetic */ ExecutionResult $executionResult;

                public final String invoke() {
                    return this.$mapper.writeValueAsString((Object)this.$executionResult.toSpecification());
                }
                {
                    this.$mapper = objectMapper;
                    this.$executionResult = executionResult2;
                    super(0);
                }
            }, this.logger, "Serialized JSON result in {}ms");
        }
        catch (InvalidDefinitionException ex) {
            String string7 = ex.getMessage();
            if (string7 != null) {
                if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"No serializer found for class graphql.execution.reactive.CompletionStageMappingPublisher", (boolean)false, (int)2, null)) {
                    ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026/subscriptions instead!\")");
                    return responseEntity;
                }
            }
            String errorMessage = "Error serializing response: " + ex.getMessage();
            ExecutionResultImpl errorResponse = new ExecutionResultImpl(GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build());
            this.logger.error(errorMessage, (Throwable)ex);
            string = mapper.writeValueAsString((Object)errorResponse.toSpecification());
        }
        String result2 = string;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)result2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(result)");
        return responseEntity;
    }

    @RequestMapping(value={"/schema.json"}, produces={"application/json"})
    @NotNull
    public final String schema() {
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        GraphQLSchema graphQLSchema = DgsSchemaProvider.schema$default((DgsSchemaProvider)this.schemaProvider, null, (int)1, null);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"ExecutionInput.newExecut\u2026\n                .build()");
        ExecutionInput executionInput2 = executionInput;
        ExecutionResult executionResult2 = graphQL.execute(executionInput2);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult2, (String)"graphQL.execute(executionInput)");
        ExecutionResult execute = executionResult2;
        String string = mapper.writeValueAsString((Object)execute.toSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsStrin\u2026xecute.toSpecification())");
        return string;
    }

    public DgsRestController(@NotNull DgsSchemaProvider schemaProvider, @NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.schemaProvider = schemaProvider;
        this.dgsQueryExecutor = dgsQueryExecutor;
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026stController::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ DgsQueryExecutor access$getDgsQueryExecutor$p(DgsRestController $this) {
        return $this.dgsQueryExecutor;
    }
}

