/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphqlErrorBuilder;
import graphql.execution.reactive.CompletionStageMappingPublisher;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\\\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0016\b\u0001\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "graphql", "Lorg/springframework/http/ResponseEntity;", "", "body", "fileParams", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "headers", "Lorg/springframework/http/HttpHeaders;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "graphql-dgs-spring-webmvc"})
public final class DgsRestController {
    @NotNull
    private final Logger logger;
    private final DgsQueryExecutor dgsQueryExecutor;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"#{@'dgs.graphql-com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties'.path}"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<String> graphql(@RequestBody @Nullable String body, @RequestParam @Nullable Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @Nullable String operation, @RequestParam(name="map") @Nullable String mapParam, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        String string;
        Object opName;
        Object it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        this.logger.debug("Starting /graphql handling");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        Map inputQuery = null;
        Map queryVariables = null;
        Map extensions = null;
        if (body != null) {
            Map map;
            Map map2;
            this.logger.debug("Reading input value: '{}'", (Object)body);
            try {
                String string2 = body;
                boolean bl2 = false;
                bl = false;
                it = string2;
                boolean bl3 = false;
                ObjectMapper $this$readValue$iv = mapper;
                boolean $i$f$readValue = false;
                String string3 = it;
                ObjectMapper objectMapper = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
                inputQuery = (Map)objectMapper.readValue(string3, typeReference);
            }
            catch (JsonParseException ex) {
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                String string4 = ex.getMessage();
                if (string4 == null) {
                    string4 = "Error parsing query - no details found in the error message";
                }
                ResponseEntity responseEntity = bodyBuilder.body((Object)string4);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026nd in the error message\")");
                return responseEntity;
            }
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                map2 = (Map)v;
            } else {
                map2 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            this.logger.debug("Parsed variables: {}", (Object)queryVariables);
        } else if (fileParams != null && mapParam != null && operation != null) {
            Map fileMapInput;
            Map map;
            Map map3;
            String ex = operation;
            boolean bl4 = false;
            bl = false;
            String it22 = ex;
            boolean bl5 = false;
            ObjectMapper $this$readValue$iv = mapper;
            boolean $i$f$readValue = false;
            String string5 = it22;
            Object object = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef22 = false;
            TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
            inputQuery = (Map)object.readValue(string5, typeReference);
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map3 = (Map)v;
            } else {
                map3 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            String string6 = mapParam;
            bl = false;
            boolean it22 = false;
            String it3 = string6;
            boolean $i$a$-let-DgsRestController$graphql$fileMapInput$22 = false;
            ObjectMapper $this$readValue$iv2 = mapper;
            boolean $i$f$readValue2 = false;
            object = it3;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv2;
            boolean $i$f$jacksonTypeRef = false;
            Object object2 = (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){};
            Map $this$forEach$iv = fileMapInput = (Map)$i$f$jacksonTypeRef22.readValue((String)object, object2);
            boolean $i$f$forEach = false;
            it = $this$forEach$iv;
            boolean bl6 = false;
            Iterator $i$a$-let-DgsRestController$graphql$fileMapInput$22 = it.entrySet().iterator();
            while ($i$a$-let-DgsRestController$graphql$fileMapInput$22.hasNext()) {
                void fileKey;
                Map.Entry element$iv;
                Map.Entry $dstr$fileKey$objectPaths = element$iv = $i$a$-let-DgsRestController$graphql$fileMapInput$22.next();
                boolean bl7 = false;
                $i$f$jacksonTypeRef22 = $dstr$fileKey$objectPaths;
                $i$f$jacksonTypeRef = false;
                object2 = (String)$i$f$jacksonTypeRef22.getKey();
                $i$f$jacksonTypeRef22 = $dstr$fileKey$objectPaths;
                $i$f$jacksonTypeRef = false;
                List objectPaths = (List)$i$f$jacksonTypeRef22.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl8 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, queryVariables, file);
                }
            }
        } else {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - no request body was provided");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026quest body was provided\")");
            return responseEntity;
        }
        Object v = opName = inputQuery.get("operationName");
        if (!(v != null ? v instanceof String : true)) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - operationName must be a String");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026onName must be a String\")");
            return responseEntity;
        }
        String gqlOperationName = (String)opName;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, inputQuery, queryVariables, extensions, headers, gqlOperationName, webRequest){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ Map $inputQuery;
            final /* synthetic */ Map $queryVariables;
            final /* synthetic */ Map $extensions;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ String $gqlOperationName;
            final /* synthetic */ WebRequest $webRequest;

            @NotNull
            public final ExecutionResult invoke() {
                V v = this.$inputQuery.get("query");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return DgsRestController.access$getDgsQueryExecutor$p(this.this$0).execute((String)v, this.$queryVariables, this.$extensions, this.$headers, this.$gqlOperationName, this.$webRequest);
            }
            {
                this.this$0 = dgsRestController;
                this.$inputQuery = map;
                this.$queryVariables = map2;
                this.$extensions = map3;
                this.$headers = httpHeaders;
                this.$gqlOperationName = string;
                this.$webRequest = webRequest;
                super(0);
            }
        }, this.logger, "Executed query in {}ms");
        this.logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        if (executionResult2.isDataPresent() && executionResult2.getData() instanceof CompletionStageMappingPublisher) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.badReques\u2026/subscriptions instead!\")");
            return responseEntity;
        }
        try {
            string = (String)TimeTracer.INSTANCE.logTime((Function0)new Function0<String>(mapper, executionResult2){
                final /* synthetic */ ObjectMapper $mapper;
                final /* synthetic */ ExecutionResult $executionResult;

                public final String invoke() {
                    return this.$mapper.writeValueAsString((Object)this.$executionResult.toSpecification());
                }
                {
                    this.$mapper = objectMapper;
                    this.$executionResult = executionResult2;
                    super(0);
                }
            }, this.logger, "Serialized JSON result in {}ms");
        }
        catch (InvalidDefinitionException ex) {
            String errorMessage = "Error serializing response: " + ex.getMessage();
            ExecutionResultImpl errorResponse = new ExecutionResultImpl(GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build());
            this.logger.error(errorMessage, (Throwable)ex);
            string = mapper.writeValueAsString((Object)errorResponse.toSpecification());
        }
        String result2 = string;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)result2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(result)");
        return responseEntity;
    }

    public DgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026stController::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ DgsQueryExecutor access$getDgsQueryExecutor$p(DgsRestController $this) {
        return $this.dgsQueryExecutor;
    }
}

