/*
 * Decompiled with CFR 0.152.
 */
package server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChannelOutputStream
extends OutputStream {
    private final Channel channel;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public ChannelOutputStream(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        ByteBuf data = Unpooled.wrappedBuffer((byte[])this.buffer.toByteArray());
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(data);
        ChannelFuture future = this.channel.writeAndFlush((Object)frame);
        future.awaitUninterruptibly();
        if (future.isCancelled()) {
            return;
        }
        if (!future.isSuccess()) {
            Throwable cause = future.cause();
            throw new IOException("Error writing MSL message to the channel.", cause);
        }
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }
}

