/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.netflix.msl.msg.MessageContext;
import com.netflix.msl.msg.MessageInputStream;
import com.netflix.msl.msg.MslControl;
import com.netflix.msl.util.MslContext;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.Attribute;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import server.ChannelOutputStream;
import server.PushConstants;
import server.msg.PushMessageContext;

public class PushMslInitHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] ACK = "ack".getBytes(UTF_8);
    private final MslControl mslCtrl;
    private final MslContext mslCtx;

    public PushMslInitHandler(MslControl mslCtrl, MslContext mslCtx) {
        this.mslCtrl = mslCtrl;
        this.mslCtx = mslCtx;
    }

    protected void messageReceived(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        MessageInputStream mis;
        ByteBuf frame = msg.content();
        byte[] framedata = frame.array();
        ByteArrayInputStream in = new ByteArrayInputStream(framedata);
        ChannelOutputStream out = new ChannelOutputStream(ctx.channel());
        PushMessageContext msgCtx = new PushMessageContext(ACK);
        Future recv = this.mslCtrl.receive(this.mslCtx, (MessageContext)msgCtx, (InputStream)in, (OutputStream)out, 60000);
        try {
            mis = (MessageInputStream)recv.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace(System.err);
            return;
        }
        if (mis == null) {
            return;
        }
        Attribute misAttr = ctx.attr(PushConstants.ATTR_KEY_MIS);
        misAttr.set((Object)mis);
    }
}

