/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.netflix.msl.MslInternalException;
import com.netflix.msl.msg.MessageContext;
import com.netflix.msl.msg.MessageInputStream;
import com.netflix.msl.msg.MslControl;
import com.netflix.msl.util.MslContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import server.ChannelOutputStream;
import server.PushConstants;
import server.msg.PushMessageContext;

public class PushMslMessage {
    private final MslControl mslCtrl;
    private final MslContext mslCtx;

    public PushMslMessage(MslControl mslCtrl, MslContext mslCtx) {
        this.mslCtrl = mslCtrl;
        this.mslCtx = mslCtx;
    }

    public void send(ChannelHandlerContext ctx, byte[] data) {
        MslControl.MslChannel channel;
        Attribute misAttr = ctx.attr(PushConstants.ATTR_KEY_MIS);
        Object o = misAttr.get();
        if (o == null || !(o instanceof MessageInputStream)) {
            throw new MslInternalException("Cannot send MSL data without having first initialized MSL communication.");
        }
        MessageInputStream mis = (MessageInputStream)o;
        PushMessageContext msgCtx = new PushMessageContext(data);
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        ChannelOutputStream out = new ChannelOutputStream(ctx.channel());
        Future resp = this.mslCtrl.push(this.mslCtx, (MessageContext)msgCtx, (InputStream)in, (OutputStream)out, mis, 60000);
        try {
            channel = (MslControl.MslChannel)resp.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace(System.err);
            return;
        }
        if (channel == null) {
            System.err.println("Push MSL channel was unexpectedly null.");
        }
    }
}

