/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.applicationautoscaling.AWSApplicationAutoScaling;
import com.amazonaws.services.applicationautoscaling.AWSApplicationAutoScalingClientBuilder;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import com.amazonaws.services.applicationautoscaling.model.MetricType;
import com.amazonaws.services.applicationautoscaling.model.PolicyType;
import com.amazonaws.services.applicationautoscaling.model.PredefinedMetricSpecification;
import com.amazonaws.services.applicationautoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import com.amazonaws.services.applicationautoscaling.model.ScalableDimension;
import com.amazonaws.services.applicationautoscaling.model.ServiceNamespace;
import com.amazonaws.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class DynamoDBAutoscalingConfigurer {
    private static final int DEFAULT_SCALE_IN_OUT_COOLDOWN = 60;
    private final AWSApplicationAutoScaling autoScalingClient;
    private final AWSSecurityTokenService securityTokenService;

    @Inject
    public DynamoDBAutoscalingConfigurer(AWSCredentialsProvider awsCredentialsProvider) {
        this.autoScalingClient = (AWSApplicationAutoScaling)((AWSApplicationAutoScalingClientBuilder)AWSApplicationAutoScalingClientBuilder.standard().withCredentials(awsCredentialsProvider)).build();
        this.securityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(awsCredentialsProvider)).build();
    }

    public void setupAutoscaling(Long readCapacityUnits, Long writeCapacityUnits, String tableName, DescribeLimitsResult limits, Integer targetWriteUtilization, Integer targetReadUtilization) {
        String resourceID = "table/" + tableName;
        String accountId = this.securityTokenService.getCallerIdentity(new GetCallerIdentityRequest()).getAccount();
        String serviceRoleArn = "arn:aws:iam::" + accountId + ":role/aws-service-role/dynamodb.application-autoscaling.amazonaws.com/AWSServiceRoleForApplicationAutoScaling_" + tableName;
        this.createAndVerifyScalableTargetAndScalingPolicy(serviceRoleArn, resourceID, ScalableDimension.DynamodbTableWriteCapacityUnits, MetricType.DynamoDBWriteCapacityUtilization, writeCapacityUnits, limits.getTableMaxWriteCapacityUnits().intValue(), targetWriteUtilization);
        this.createAndVerifyScalableTargetAndScalingPolicy(serviceRoleArn, resourceID, ScalableDimension.DynamodbTableReadCapacityUnits, MetricType.DynamoDBReadCapacityUtilization, readCapacityUnits, limits.getTableMaxReadCapacityUnits().intValue(), targetReadUtilization);
    }

    private void createAndVerifyScalableTargetAndScalingPolicy(String serviceRoleArn, String resourceID, ScalableDimension scalableDimension, MetricType metricType, Long capacityUnits, Integer maxCapacityUnits, Integer utilizationTarget) {
        this.createAndVerifyScalableTarget(resourceID, serviceRoleArn, scalableDimension, capacityUnits.intValue(), maxCapacityUnits);
        this.createAndVerifyScalingPolicy(resourceID, scalableDimension, metricType, utilizationTarget.doubleValue());
    }

    private void createAndVerifyScalingPolicy(String resourceID, ScalableDimension scalableDimension, MetricType metricType, Double targetValue) {
        String scalingPolicyArn;
        TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration = new TargetTrackingScalingPolicyConfiguration().withPredefinedMetricSpecification(new PredefinedMetricSpecification().withPredefinedMetricType(metricType)).withTargetValue(targetValue).withScaleInCooldown(Integer.valueOf(60)).withScaleOutCooldown(Integer.valueOf(60));
        PutScalingPolicyRequest pspRequest = new PutScalingPolicyRequest().withServiceNamespace(ServiceNamespace.Dynamodb).withScalableDimension(scalableDimension).withResourceId(resourceID).withPolicyName("My" + scalableDimension.name() + "ScalingPolicy").withPolicyType(PolicyType.TargetTrackingScaling).withTargetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration);
        try {
            scalingPolicyArn = this.autoScalingClient.putScalingPolicy(pspRequest).getPolicyARN();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to put scaling policy", e);
        }
        DescribeScalingPoliciesRequest dspRequest = new DescribeScalingPoliciesRequest().withServiceNamespace(ServiceNamespace.Dynamodb).withScalableDimension(scalableDimension).withResourceId(resourceID);
        try {
            this.autoScalingClient.describeScalingPolicies(dspRequest).getScalingPolicies().stream().filter(scalingPolicy -> scalingPolicy.getPolicyARN().equals(scalingPolicyArn)).findFirst().orElseThrow(() -> new IllegalStateException("Scaling policy was created but arn did not match"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to verify scaling policy", e);
        }
    }

    private void createAndVerifyScalableTarget(String resourceID, String serviceRoleArn, ScalableDimension scalableDimension, Integer minimumCapacity, Integer maximumCapacity) {
        RegisterScalableTargetRequest rstRequest = new RegisterScalableTargetRequest().withServiceNamespace(ServiceNamespace.Dynamodb).withResourceId(resourceID).withScalableDimension(scalableDimension).withMinCapacity(minimumCapacity).withMaxCapacity(maximumCapacity).withRoleARN(serviceRoleArn);
        try {
            this.autoScalingClient.registerScalableTarget(rstRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to register scalable target", e);
        }
        DescribeScalableTargetsRequest dscRequest = new DescribeScalableTargetsRequest().withServiceNamespace(ServiceNamespace.Dynamodb).withScalableDimension(scalableDimension).withResourceIds(new String[]{resourceID});
        try {
            this.autoScalingClient.describeScalableTargets(dscRequest).getScalableTargets().stream().filter(target -> target.getResourceId().equals(resourceID) && target.getScalableDimension().equals(scalableDimension.toString()) && target.getServiceNamespace().equals(ServiceNamespace.Dynamodb.toString()) && target.getMinCapacity().equals(minimumCapacity) && target.getMaxCapacity().equals(maximumCapacity) && target.getRoleARN().equals(serviceRoleArn)).findFirst().orElseThrow(() -> new IllegalStateException("Target was created but not all fields matched"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to verify scalable target", e);
        }
    }
}

