/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.api.plugin.NdBenchClient;
import com.netflix.ndbench.api.plugin.annotations.NdBenchClientPlugin;
import com.netflix.ndbench.plugin.dynamodb.DynamoDBKeyValueBase;
import com.netflix.ndbench.plugin.dynamodb.configs.DynamoDBConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@NdBenchClientPlugin(value="DynamoDBKeyValue")
public class DynamoDBKeyValue
extends DynamoDBKeyValueBase<DynamoDBConfiguration>
implements NdBenchClient {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBKeyValue.class);

    @Inject
    public DynamoDBKeyValue(AWSCredentialsProvider awsCredentialsProvider, DynamoDBConfiguration configuration) {
        super(awsCredentialsProvider, configuration);
    }

    @Override
    public void init(DataGenerator dataGenerator) {
        logger.info("Initializing AWS SDK clients");
        this.createAndSetDynamoDBClient();
        this.instantiateDataPlaneOperations(dataGenerator);
        logger.info("DynamoDB Plugin initialized");
    }

    @Override
    public String getConnectionInfo() {
        return String.format("Table Name - %s : Attribute Name - %s : Consistent Read - %b", ((DynamoDBConfiguration)this.config).getTableName(), ((DynamoDBConfiguration)this.config).getAttributeName(), ((DynamoDBConfiguration)this.config).consistentRead());
    }

    AmazonDynamoDB getDynamoDB() {
        return this.dynamoDB;
    }
}

