/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.google.common.base.Preconditions;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.api.plugin.NdBenchClient;
import com.netflix.ndbench.plugin.dynamodb.configs.DynamoDBConfigurationBase;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.DynamoDBReadBulk;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.DynamoDBReadSingle;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.DynamoDBWriteBulk;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.DynamoDBWriteSingle;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.DynamoDBWriteTransaction;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamoDBKeyValueBase<C extends DynamoDBConfigurationBase>
implements NdBenchClient {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBKeyValueBase.class);
    private static final boolean DO_HONOR_MAX_ERROR_RETRY_IN_CLIENT_CONFIG = true;
    protected final AWSCredentialsProvider awsCredentialsProvider;
    protected final C config;
    protected AmazonDynamoDB dynamoDB;
    protected DynamoDBReadSingle singleRead;
    protected DynamoDBReadBulk bulkRead;
    protected DynamoDBWriteSingle singleWrite;
    protected DynamoDBWriteBulk bulkWrite;
    protected DynamoDBWriteTransaction transactionWrite;

    protected DynamoDBKeyValueBase(AWSCredentialsProvider awsCredentialsProvider, C configuration) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.config = configuration;
    }

    protected void instantiateDataPlaneOperations(DataGenerator dataGenerator) {
        String tableName = this.config.getTableName();
        String partitionKeyName = this.config.getAttributeName();
        ReturnConsumedCapacity returnConsumedCapacity = ReturnConsumedCapacity.NONE;
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)tableName));
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)partitionKeyName));
        boolean consistentRead = this.config.consistentRead();
        this.singleRead = new DynamoDBReadSingle(dataGenerator, this.dynamoDB, tableName, partitionKeyName, consistentRead, returnConsumedCapacity);
        this.bulkRead = new DynamoDBReadBulk(dataGenerator, this.dynamoDB, tableName, partitionKeyName, consistentRead, returnConsumedCapacity);
        this.singleWrite = new DynamoDBWriteSingle(dataGenerator, this.dynamoDB, tableName, partitionKeyName, returnConsumedCapacity);
        this.bulkWrite = new DynamoDBWriteBulk(dataGenerator, this.dynamoDB, tableName, partitionKeyName, returnConsumedCapacity);
        this.transactionWrite = new DynamoDBWriteTransaction(dataGenerator, this.dynamoDB, tableName, partitionKeyName, this.config.getChildTableNamePrefix(), this.config.getMainTableColsPerRow(), returnConsumedCapacity);
    }

    protected void createAndSetDynamoDBClient() {
        AmazonDynamoDBClientBuilder dynamoDbBuilder = AmazonDynamoDBClientBuilder.standard();
        dynamoDbBuilder.withClientConfiguration(new ClientConfiguration().withMaxConnections(this.config.getMaxConnections().intValue()).withRequestTimeout(this.config.getMaxRequestTimeout().intValue()).withRetryPolicy(this.config.getMaxRetries() <= 0 ? PredefinedRetryPolicies.NO_RETRY_POLICY : new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DYNAMODB_DEFAULT_BACKOFF_STRATEGY, this.config.getMaxRetries().intValue(), true)).withGzip(this.config.isCompressing().booleanValue()));
        dynamoDbBuilder.withCredentials(this.awsCredentialsProvider);
        if (StringUtils.isNotEmpty((String)this.config.getEndpoint())) {
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.config.getRegion()), (Object)"If you set the endpoint you must set the region");
            dynamoDbBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.config.getEndpoint(), this.config.getRegion()));
        }
        this.dynamoDB = (AmazonDynamoDB)dynamoDbBuilder.build();
    }

    public abstract void init(DataGenerator var1);

    public String readSingle(String key) {
        return this.singleRead.apply(key);
    }

    public String writeSingle(String key) {
        return this.singleWrite.apply(key);
    }

    public List<String> readBulk(List<String> keys) {
        return this.bulkRead.apply(keys);
    }

    public List<String> writeBulk(List<String> keys) {
        return this.bulkWrite.apply(keys);
    }

    public void shutdown() {
        this.dynamoDB.shutdown();
        logger.info("DynamoDB shutdown");
    }

    public String getConnectionInfo() {
        return String.format("Table Name - %s : Attribute Name - %s : Consistent Read - %b", this.config.getTableName(), this.config.getAttributeName(), this.config.consistentRead());
    }

    public String runWorkFlow() {
        return null;
    }

    double getAndResetReadCounsumed() {
        return this.singleRead.getAndResetConsumed() + this.bulkRead.getAndResetConsumed();
    }

    double getAndResetWriteCounsumed() {
        return this.singleWrite.getAndResetConsumed() + this.bulkWrite.getAndResetConsumed();
    }
}

