/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.Statistic;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.api.plugin.NdBenchClient;
import com.netflix.ndbench.api.plugin.annotations.NdBenchClientPlugin;
import com.netflix.ndbench.plugin.dynamodb.DynamoDBAutoscalingConfigurer;
import com.netflix.ndbench.plugin.dynamodb.DynamoDBKeyValueBase;
import com.netflix.ndbench.plugin.dynamodb.configs.ProgrammaticDynamoDBConfiguration;
import com.netflix.ndbench.plugin.dynamodb.operations.cloudwatch.controlplane.PutMetricAlarmOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.cloudwatch.dataplane.PutMetricDataOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.controlplane.CreateDynamoDBTable;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.controlplane.DeleteDynamoDBTable;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.controlplane.DescribeLimits;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@NdBenchClientPlugin(value="DynamoDBProgrammaticKeyValue")
public class DynamoDBProgrammaticKeyValue
extends DynamoDBKeyValueBase<ProgrammaticDynamoDBConfiguration>
implements NdBenchClient {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBProgrammaticKeyValue.class);
    private static final String ND_BENCH_DYNAMO_DB_CONSUMED_RCU = "ConsumedRcuHighRes";
    private static final String ND_BENCH_DYNAMO_DB_CONSUMED_WCU = "ConsumedWcuHighRes";
    private static final String CUSTOM_TABLE_METRICS_NAMESPACE = "ndbench/DynamoDB";
    private final AtomicReference<ExecutorService> cloudwatchReporterExecutor = new AtomicReference<Object>(null);
    private DynamoDBAutoscalingConfigurer dynamoDBAutoscalingConfigurer;
    private AmazonCloudWatch cloudWatch;
    private CreateDynamoDBTable createTable;
    private DeleteDynamoDBTable deleteTable;
    private DescribeLimits describeLimits;
    private PutMetricDataOperation putMetricData;
    private PutMetricAlarmOperation putMetricAlarm;
    private long publishingInterval;
    private Dimension tableDimension;

    @Inject
    public DynamoDBProgrammaticKeyValue(AWSCredentialsProvider awsCredentialsProvider, ProgrammaticDynamoDBConfiguration configuration, DynamoDBAutoscalingConfigurer dynamoDBAutoscalingConfigurer) {
        super(awsCredentialsProvider, configuration);
        this.dynamoDBAutoscalingConfigurer = dynamoDBAutoscalingConfigurer;
    }

    @Override
    public void init(DataGenerator dataGenerator) {
        this.createAndSetDynamoDBClient();
        this.instantiateDataPlaneOperations(dataGenerator);
        String tableName = ((ProgrammaticDynamoDBConfiguration)this.config).getTableName();
        String partitionKeyName = ((ProgrammaticDynamoDBConfiguration)this.config).getAttributeName();
        long rcu = Long.parseLong(((ProgrammaticDynamoDBConfiguration)this.config).getReadCapacityUnits());
        long wcu = Long.parseLong(((ProgrammaticDynamoDBConfiguration)this.config).getWriteCapacityUnits());
        this.publishingInterval = ((ProgrammaticDynamoDBConfiguration)this.config).getHighResolutionMetricsPublishingInterval();
        this.tableDimension = new Dimension().withName("TableName").withValue(tableName);
        this.describeLimits = new DescribeLimits(this.dynamoDB, tableName, partitionKeyName);
        this.createTable = new CreateDynamoDBTable(this.dynamoDB, tableName, partitionKeyName, rcu, wcu);
        this.deleteTable = new DeleteDynamoDBTable(this.dynamoDB, tableName, partitionKeyName);
        logger.info("Creating table programmatically");
        TableDescription td = this.createTable.get();
        logger.info("Table Description: " + td.toString());
        DescribeLimitsResult limits = this.describeLimits.get();
        if (((ProgrammaticDynamoDBConfiguration)this.config).getAutoscaling().booleanValue()) {
            this.dynamoDBAutoscalingConfigurer.setupAutoscaling(rcu, wcu, ((ProgrammaticDynamoDBConfiguration)this.config).getTableName(), limits, Integer.valueOf(((ProgrammaticDynamoDBConfiguration)this.config).getTargetWriteUtilization()), Integer.valueOf(((ProgrammaticDynamoDBConfiguration)this.config).getTargetReadUtilization()));
        }
        AmazonCloudWatchClientBuilder cloudWatchClientBuilder = AmazonCloudWatchClientBuilder.standard();
        cloudWatchClientBuilder.withCredentials(this.awsCredentialsProvider);
        if (StringUtils.isNotEmpty((String)((ProgrammaticDynamoDBConfiguration)this.config).getRegion())) {
            cloudWatchClientBuilder.withRegion(Regions.fromName((String)((ProgrammaticDynamoDBConfiguration)this.config).getRegion()));
        }
        this.cloudWatch = (AmazonCloudWatch)cloudWatchClientBuilder.build();
        this.putMetricAlarm = new PutMetricAlarmOperation(this.cloudWatch);
        this.putMetricData = new PutMetricDataOperation(this.cloudWatch);
        if (((ProgrammaticDynamoDBConfiguration)this.config).publishHighResolutionConsumptionMetrics().booleanValue()) {
            logger.info("Initializing CloudWatch reporter");
            this.checkAndInitCloudwatchReporter();
        }
        if (((ProgrammaticDynamoDBConfiguration)this.config).alarmOnHighResolutionConsumptionMetrics().booleanValue()) {
            Preconditions.checkState((boolean)((ProgrammaticDynamoDBConfiguration)this.config).publishHighResolutionConsumptionMetrics());
            double thresholdPercentage = ((ProgrammaticDynamoDBConfiguration)this.config).highResolutionAlarmThresholdPercentageOfProvisionedCapacity();
            this.createHighResolutionAlarm("ndbench/DynamoDB/RcuConsumedAlarm", ND_BENCH_DYNAMO_DB_CONSUMED_RCU, thresholdPercentage * (double)rcu);
            this.createHighResolutionAlarm("ndbench/DynamoDB/WcuConsumedAlarm", ND_BENCH_DYNAMO_DB_CONSUMED_WCU, thresholdPercentage * (double)wcu);
        }
    }

    private void createHighResolutionAlarm(String alarmName, String metricName, double threshold) {
        this.putMetricAlarm.apply(new PutMetricAlarmRequest().withNamespace(CUSTOM_TABLE_METRICS_NAMESPACE).withDimensions(new Dimension[]{this.tableDimension}).withMetricName(metricName).withAlarmName(alarmName).withStatistic(Statistic.Sum).withUnit(StandardUnit.Count).withComparisonOperator(ComparisonOperator.GreaterThanThreshold).withDatapointsToAlarm(Integer.valueOf(5)).withEvaluationPeriods(Integer.valueOf(5)).withActionsEnabled(Boolean.valueOf(false)).withPeriod(Integer.valueOf(10)).withThreshold(Double.valueOf(10.0 * threshold)));
    }

    private void checkAndInitCloudwatchReporter() {
        ExecutorService timer = this.cloudwatchReporterExecutor.get();
        if (timer == null) {
            timer = Executors.newFixedThreadPool(1);
            timer.submit(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    Date now = Date.from(Instant.now());
                    this.putMetricData.apply(new PutMetricDataRequest().withNamespace(CUSTOM_TABLE_METRICS_NAMESPACE).withMetricData(new MetricDatum[]{this.createConsumedRcuDatum(now), this.createConsumedWcuDatum(now)}));
                    Thread.sleep(this.publishingInterval);
                }
                return null;
            });
        }
        this.cloudwatchReporterExecutor.set(timer);
    }

    private MetricDatum createConsumedRcuDatum(Date now) {
        return this.createCapacityUnitMetricDatumAndResetCounter(now, this.getAndResetReadCounsumed(), ND_BENCH_DYNAMO_DB_CONSUMED_RCU);
    }

    private MetricDatum createConsumedWcuDatum(Date now) {
        return this.createCapacityUnitMetricDatumAndResetCounter(now, this.getAndResetWriteCounsumed(), ND_BENCH_DYNAMO_DB_CONSUMED_WCU);
    }

    private MetricDatum createCapacityUnitMetricDatumAndResetCounter(Date now, double count, String name) {
        return new MetricDatum().withDimensions(new Dimension[]{this.tableDimension}).withMetricName(name).withStorageResolution(Integer.valueOf(1)).withUnit(StandardUnit.Count).withTimestamp(now).withValue(Double.valueOf(count));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.cloudwatchReporterExecutor.get() != null) {
            this.cloudwatchReporterExecutor.get().shutdownNow();
            this.cloudwatchReporterExecutor.set(null);
        }
        this.cloudWatch.shutdown();
        logger.info("CloudWatch shutdown");
        this.deleteTable.delete();
    }
}

