/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.google.common.base.Preconditions;
import com.netflix.ndbench.plugin.dynamodb.operations.AbstractAwsOperation;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDynamoDBOperation
extends AbstractAwsOperation {
    protected static final String ATTRIBUTE_NAME = "value";
    protected final AmazonDynamoDB dynamoDB;
    protected final String tableName;
    protected final String partitionKeyName;

    protected AbstractDynamoDBOperation(AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName) {
        Preconditions.checkNotNull((Object)dynamoDB, (Object)"DynamoDB client must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"Invalid table name");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)partitionKeyName), (Object)"Invalid partition key name");
        this.dynamoDB = dynamoDB;
        this.tableName = tableName;
        this.partitionKeyName = partitionKeyName;
    }
}

