/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.controlplane;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import com.google.common.base.Preconditions;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.AbstractDynamoDBOperation;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDynamoDBTable
extends AbstractDynamoDBOperation
implements Supplier<TableDescription> {
    private static final Logger logger = LoggerFactory.getLogger(CreateDynamoDBTable.class);
    private final long readCapacityUnits;
    private final long writeCapacityUnits;

    public CreateDynamoDBTable(AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, long readCapacityUnits, long writeCapacityUnits) {
        super(dynamoDB, tableName, partitionKeyName);
        Preconditions.checkArgument((readCapacityUnits > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((writeCapacityUnits > 0L ? 1 : 0) != 0);
        this.readCapacityUnits = readCapacityUnits;
        this.writeCapacityUnits = writeCapacityUnits;
    }

    @Override
    public TableDescription get() {
        logger.debug("Creating table if it does not exist yet");
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(this.partitionKeyName).withKeyType(KeyType.HASH));
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(this.partitionKeyName).withAttributeType(ScalarAttributeType.S));
        CreateTableRequest request = new CreateTableRequest().withTableName(this.tableName).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(this.readCapacityUnits)).withWriteCapacityUnits(Long.valueOf(this.writeCapacityUnits)));
        logger.info("Creating Table: " + this.tableName);
        try {
            return this.dynamoDB.describeTable(this.tableName).getTable();
        }
        catch (ResourceNotFoundException e) {
            TableDescription tableDescription = this.dynamoDB.createTable(request).getTableDescription();
            logger.debug("Waiting until the table is in ACTIVE state");
            try {
                TableUtils.waitUntilActive((AmazonDynamoDB)this.dynamoDB, (String)this.tableName);
            }
            catch (InterruptedException e1) {
                throw new IllegalStateException("Table interrupted exception", e);
            }
            return tableDescription;
        }
    }
}

