/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.controlplane;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.AbstractDynamoDBOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDynamoDBTable
extends AbstractDynamoDBOperation {
    private static final Logger logger = LoggerFactory.getLogger(DeleteDynamoDBTable.class);
    private final Table table;

    public DeleteDynamoDBTable(AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName) {
        super(dynamoDB, tableName, partitionKeyName);
        this.table = new Table(dynamoDB, tableName);
    }

    public void delete() {
        try {
            logger.info("Issuing DeleteTable request for " + this.tableName);
            this.table.delete();
            logger.info("Waiting for " + this.tableName + " to be deleted...this may take a while...");
            this.table.waitForDelete();
        }
        catch (ResourceNotFoundException e) {
            logger.info("Table was already deleted");
        }
        catch (Exception e) {
            throw new IllegalStateException("DeleteTable request failed for " + this.tableName, e);
        }
    }
}

