/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.AbstractDynamoDBOperation;
import java.util.List;

public class AbstractDynamoDBDataPlaneOperation
extends AbstractDynamoDBOperation {
    protected final DataGenerator dataGenerator;
    protected final AtomicDouble consumed = new AtomicDouble(0.0);
    protected final ReturnConsumedCapacity returnConsumedCapacity;

    protected AbstractDynamoDBDataPlaneOperation(AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, DataGenerator dataGenerator, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dynamoDB, tableName, partitionKeyName);
        this.dataGenerator = dataGenerator;
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    protected double getConsumedCapacityForTable(List<ConsumedCapacity> consumedCapacities) {
        Preconditions.checkNotNull(consumedCapacities);
        return consumedCapacities.stream().filter(c -> this.tableName.equals(c.getTableName())).map(ConsumedCapacity::getCapacityUnits).findFirst().orElse(0.0);
    }

    public double getAndResetConsumed() {
        return this.consumed.getAndSet(0.0);
    }
}

