/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.AbstractDynamoDBReadOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.CapacityConsumingFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamoDBReadBulk
extends AbstractDynamoDBReadOperation
implements CapacityConsumingFunction<BatchGetItemResult, List<String>, List<String>> {
    public DynamoDBReadBulk(DataGenerator dataGenerator, AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, boolean consistentRead, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dataGenerator, dynamoDB, tableName, partitionKeyName, consistentRead, returnConsumedCapacity);
    }

    @Override
    public List<String> apply(List<String> keys) {
        Preconditions.checkArgument((new HashSet<String>(keys).size() == keys.size() ? 1 : 0) != 0);
        KeysAndAttributes keysAndAttributes = this.generateReadRequests(keys);
        try {
            this.readUntilDone(keysAndAttributes);
            return keysAndAttributes.getKeys().stream().map(Object::toString).collect(Collectors.toList());
        }
        catch (AmazonServiceException ase) {
            throw this.amazonServiceException(ase);
        }
        catch (AmazonClientException ace) {
            throw this.amazonClientException(ace);
        }
    }

    private KeysAndAttributes generateReadRequests(List<String> keys) {
        return new KeysAndAttributes().withKeys((Collection)keys.stream().map(key -> ImmutableMap.of((Object)"id", (Object)new AttributeValue(key))).collect(Collectors.toList())).withConsistentRead(Boolean.valueOf(this.consistentRead));
    }

    private void readUntilDone(KeysAndAttributes keysAndAttributes) {
        BatchGetItemResult result;
        KeysAndAttributes remainingKeys = keysAndAttributes;
        do {
            remainingKeys.withConsistentRead(Boolean.valueOf(this.consistentRead));
        } while ((remainingKeys = (KeysAndAttributes)(result = this.runBatchGetRequest(remainingKeys)).getUnprocessedKeys().get(this.tableName)) != null && remainingKeys.getKeys() != null && !remainingKeys.getKeys().isEmpty());
    }

    private BatchGetItemResult runBatchGetRequest(KeysAndAttributes keysAndAttributes) {
        return this.measureConsumedCapacity(this.dynamoDB.batchGetItem(new BatchGetItemRequest().withRequestItems((Map)ImmutableMap.of((Object)this.tableName, (Object)keysAndAttributes)).withReturnConsumedCapacity(this.returnConsumedCapacity)));
    }

    @Override
    public BatchGetItemResult measureConsumedCapacity(BatchGetItemResult result) {
        this.consumed.addAndGet(result.getConsumedCapacity() == null ? 0.0 : this.getConsumedCapacityForTable(result.getConsumedCapacity()));
        return result;
    }
}

