/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.google.common.collect.ImmutableMap;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.AbstractDynamoDBReadOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.CapacityConsumingFunction;
import java.util.Map;
import java.util.Optional;

public class DynamoDBReadSingle
extends AbstractDynamoDBReadOperation
implements CapacityConsumingFunction<GetItemResult, String, String> {
    public DynamoDBReadSingle(DataGenerator dataGenerator, AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, boolean consistentRead, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dataGenerator, dynamoDB, tableName, partitionKeyName, consistentRead, returnConsumedCapacity);
    }

    @Override
    public String apply(String key) {
        GetItemRequest request = new GetItemRequest().withTableName(this.tableName).withKey((Map)ImmutableMap.of((Object)this.partitionKeyName, (Object)new AttributeValue(key))).withReturnConsumedCapacity(this.returnConsumedCapacity).withConsistentRead(Boolean.valueOf(this.consistentRead));
        try {
            return Optional.ofNullable(this.dynamoDB.getItem(request)).map(this::measureConsumedCapacity).map(GetItemResult::getItem).map(Object::toString).orElse(null);
        }
        catch (AmazonServiceException ase) {
            throw this.amazonServiceException(ase);
        }
        catch (AmazonClientException ace) {
            throw this.amazonClientException(ace);
        }
    }

    @Override
    public GetItemResult measureConsumedCapacity(GetItemResult result) {
        ConsumedCapacity consumedCapacity = result.getConsumedCapacity();
        if (consumedCapacity != null && consumedCapacity.getCapacityUnits() != null) {
            this.consumed.addAndGet(result.getConsumedCapacity().getCapacityUnits().doubleValue());
        }
        return result;
    }
}

