/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.AbstractDynamoDBDataPlaneOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.CapacityConsumingFunction;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamoDBWriteBulk
extends AbstractDynamoDBDataPlaneOperation
implements CapacityConsumingFunction<BatchWriteItemResult, List<String>, List<String>> {
    public DynamoDBWriteBulk(DataGenerator dataGenerator, AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dynamoDB, tableName, partitionKeyName, dataGenerator, returnConsumedCapacity);
    }

    @Override
    public List<String> apply(List<String> keys) {
        Preconditions.checkArgument((new HashSet<String>(keys).size() == keys.size() ? 1 : 0) != 0);
        List<WriteRequest> writeRequests = this.generateWriteRequests(keys);
        try {
            this.writeUntilDone(writeRequests);
            return writeRequests.stream().map(WriteRequest::getPutRequest).map(PutRequest::toString).collect(Collectors.toList());
        }
        catch (AmazonServiceException ase) {
            throw this.amazonServiceException(ase);
        }
        catch (AmazonClientException ace) {
            throw this.amazonClientException(ace);
        }
    }

    private List<WriteRequest> generateWriteRequests(List<String> keys) {
        return keys.stream().map(key -> ImmutableMap.of((Object)this.partitionKeyName, (Object)new AttributeValue(key), (Object)"value", (Object)new AttributeValue(this.dataGenerator.getRandomValue()))).map(item -> new PutRequest().withItem((Map)item)).map(put -> new WriteRequest().withPutRequest(put)).collect(Collectors.toList());
    }

    private void writeUntilDone(List<WriteRequest> requests) {
        BatchWriteItemResult result;
        List remainingRequests = requests;
        while ((remainingRequests = (List)(result = this.runBatchWriteRequest(remainingRequests)).getUnprocessedItems().get(this.tableName)) != null && remainingRequests.isEmpty()) {
        }
    }

    private BatchWriteItemResult runBatchWriteRequest(List<WriteRequest> writeRequests) {
        return this.measureConsumedCapacity(this.dynamoDB.batchWriteItem(new BatchWriteItemRequest().withRequestItems((Map)ImmutableMap.of((Object)this.tableName, writeRequests)).withReturnConsumedCapacity(this.returnConsumedCapacity)));
    }

    @Override
    public BatchWriteItemResult measureConsumedCapacity(BatchWriteItemResult result) {
        this.consumed.addAndGet(result.getConsumedCapacity() == null ? 0.0 : this.getConsumedCapacityForTable(result.getConsumedCapacity()));
        return result;
    }
}

