/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.AbstractDynamoDBDataPlaneOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.CapacityConsumingFunction;
import java.util.Optional;

public class DynamoDBWriteSingle
extends AbstractDynamoDBDataPlaneOperation
implements CapacityConsumingFunction<PutItemResult, String, String> {
    public DynamoDBWriteSingle(DataGenerator dataGenerator, AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dynamoDB, tableName, partitionKeyName, dataGenerator, returnConsumedCapacity);
    }

    @Override
    public String apply(String key) {
        PutItemRequest request = new PutItemRequest().withTableName(this.tableName).withReturnConsumedCapacity(this.returnConsumedCapacity).addItemEntry(this.partitionKeyName, new AttributeValue().withS(key)).addItemEntry("value", new AttributeValue().withS(this.dataGenerator.getRandomValue()));
        try {
            return Optional.ofNullable(this.dynamoDB.putItem(request)).map(this::measureConsumedCapacity).map(PutItemResult::toString).orElse(null);
        }
        catch (AmazonServiceException ase) {
            throw this.amazonServiceException(ase);
        }
        catch (AmazonClientException ace) {
            throw this.amazonClientException(ace);
        }
    }

    @Override
    public PutItemResult measureConsumedCapacity(PutItemResult result) {
        ConsumedCapacity consumedCapacity = result.getConsumedCapacity();
        if (consumedCapacity != null && consumedCapacity.getCapacityUnits() != null) {
            this.consumed.addAndGet(result.getConsumedCapacity().getCapacityUnits().doubleValue());
        }
        return result;
    }
}

