/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane;

import com.amazonaws.services.cloudwatch.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactionCanceledException;
import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.AbstractDynamoDBDataPlaneOperation;
import com.netflix.ndbench.plugin.dynamodb.operations.dynamodb.dataplane.CapacityConsumingFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBWriteTransaction
extends AbstractDynamoDBDataPlaneOperation
implements CapacityConsumingFunction<PutItemResult, String, String> {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBWriteTransaction.class);
    private static final String ResultOK = "Ok";
    private static final String ResultFailed = "Failed";
    private String childTableNamePrefix;
    private int mainTableColsPerRow;

    public DynamoDBWriteTransaction(DataGenerator dataGenerator, AmazonDynamoDB dynamoDB, String tableName, String partitionKeyName, String childTableNamePrefix, int mainTableColsPerRow, ReturnConsumedCapacity returnConsumedCapacity) {
        super(dynamoDB, tableName, partitionKeyName, dataGenerator, returnConsumedCapacity);
        this.childTableNamePrefix = childTableNamePrefix;
        this.mainTableColsPerRow = mainTableColsPerRow;
    }

    @Override
    public String apply(String key) {
        ArrayList<TransactWriteItem> writes = new ArrayList<TransactWriteItem>();
        HashMap<String, AttributeValue> mainTableItem = new HashMap<String, AttributeValue>();
        mainTableItem.put(this.partitionKeyName, new AttributeValue(key));
        for (int i = 0; i < this.mainTableColsPerRow; ++i) {
            String value = this.dataGenerator.getRandomValue();
            mainTableItem.put(this.childTableNamePrefix + i, new AttributeValue(value));
            HashMap<String, AttributeValue> childTableItem = new HashMap<String, AttributeValue>();
            childTableItem.put(this.partitionKeyName, new AttributeValue(value));
            Put childTableEntry = new Put().withTableName(this.childTableNamePrefix + i).withItem(childTableItem).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
            writes.add(new TransactWriteItem().withPut(childTableEntry));
        }
        Put mainTableEntry = new Put().withTableName(this.tableName).withItem(mainTableItem).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        writes.add(new TransactWriteItem().withPut(mainTableEntry));
        TransactWriteItemsRequest placeWriteTransaction = new TransactWriteItemsRequest().withTransactItems(writes).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        try {
            this.dynamoDB.transactWriteItems(placeWriteTransaction);
            return ResultOK;
        }
        catch (ResourceNotFoundException rnf) {
            logger.error("One of the table involved in the transaction is not found" + (Object)((Object)rnf));
            throw rnf;
        }
        catch (InternalServerErrorException ise) {
            logger.error("Internal Server Error" + (Object)((Object)ise));
            throw ise;
        }
        catch (TransactionCanceledException tce) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Transaction cancelled. %s", new Object[]{tce}));
            List cancellationReasonList = tce.getCancellationReasons();
            if (cancellationReasonList != null) {
                for (CancellationReason cancellationReason : cancellationReasonList) {
                    sb.append(String.format("Cancellation reason: %s", cancellationReason.getMessage()));
                }
            }
            logger.warn(sb.toString());
            throw tce;
        }
    }

    @Override
    public PutItemResult measureConsumedCapacity(PutItemResult result) {
        ConsumedCapacity consumedCapacity = result.getConsumedCapacity();
        if (consumedCapacity != null && consumedCapacity.getCapacityUnits() != null) {
            this.consumed.addAndGet(result.getConsumedCapacity().getCapacityUnits().doubleValue());
        }
        return result;
    }
}

