/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.janusgraph;

import com.netflix.ndbench.api.plugin.DataGenerator;
import com.netflix.ndbench.api.plugin.NdBenchClient;
import com.netflix.ndbench.api.plugin.annotations.NdBenchClientPlugin;
import com.netflix.ndbench.plugin.janusgraph.JanusGraphBasePlugin;
import com.netflix.ndbench.plugin.janusgraph.configs.IJanusGraphConfig;
import com.netflix.ndbench.plugin.janusgraph.cql.JanusGraphBuilderCQLProvider;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.T;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@NdBenchClientPlugin(value="janusgraph-cql")
public class JanusGraphPluginCQL
extends JanusGraphBasePlugin
implements NdBenchClient {
    private static final Logger logger = LoggerFactory.getLogger(JanusGraphPluginCQL.class);
    private static String BACKEND = "cql";
    private final JanusGraphFactory.Builder graphBuilder;
    private DataGenerator dataGenerator;
    private GraphTraversalSource traversalSource;
    private JanusGraph graph;
    private boolean useJanusgraphTransaction;

    @Inject
    public JanusGraphPluginCQL(IJanusGraphConfig config, JanusGraphBuilderCQLProvider builderProvider) {
        super(BACKEND, Optional.ofNullable(config.getStorageHostname()).orElse(Inet4Address.getLoopbackAddress().getHostAddress()), config.getStoragePort());
        this.graphBuilder = builderProvider.getGraphBuilder();
        this.useJanusgraphTransaction = config.useJanusgraphTransaction();
    }

    public void init(DataGenerator dataGenerator) throws Exception {
        this.graph = this.graphBuilder.open();
        this.traversalSource = this.graph.traversal();
        this.dataGenerator = dataGenerator;
        this.createSchema(this.graph);
        logger.info("Initing JanusGraph Plugin CQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readSingle(String key) throws Exception {
        try (JanusGraphTransaction tx = this.useJanusgraphTransaction ? this.graph.newTransaction() : null;){
            String string = this.readSingleInternal(key, tx);
            return string;
        }
    }

    private String readSingleInternal(String key, JanusGraphTransaction transaction) throws Exception {
        String response = "ok";
        if (this.useJanusgraphTransaction) {
            if (transaction == null) {
                throw new IllegalArgumentException("JanusGraph transaction in read operation is null");
            }
            JanusGraphVertex vertex = (JanusGraphVertex)transaction.query().has("prop_customId", (Object)key).vertices();
            if (vertex == null) {
                throw new Exception("Internal error when reading data with key" + key + " using JanusGraph Core API");
            }
            if (vertex.keys().isEmpty()) {
                response = CACHE_MISS;
            }
        } else {
            List results = this.traversalSource.V(new Object[0]).has("prop_customId", (Object)key).toList();
            if (results == null) {
                throw new Exception("Internal error when reading data with key" + key + " using TinkerPop API");
            }
            if (results.size() == 0) {
                response = CACHE_MISS;
            }
        }
        return response;
    }

    public String writeSingle(String key) throws Exception {
        if (this.useJanusgraphTransaction) {
            this.graph.addVertex(new Object[]{T.label, "level1", "prop_customId", key, "metadata", this.dataGenerator.getRandomValue()});
            this.graph.tx().commit();
        } else {
            this.traversalSource.getGraph().addVertex(new Object[]{T.label, "level1", "prop_customId", key, "metadata", this.dataGenerator.getRandomValue()});
            this.traversalSource.getGraph().tx().commit();
        }
        return "ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readBulk(List<String> keys) throws Exception {
        ArrayList<String> responses = new ArrayList<String>(keys.size());
        try (JanusGraphTransaction transaction = this.useJanusgraphTransaction ? this.graph.newTransaction() : null;){
            for (String key : keys) {
                String response = this.readSingleInternal(key, transaction);
                responses.add(response);
            }
        }
        return responses;
    }

    public List<String> writeBulk(List<String> keys) throws Exception {
        ArrayList<String> responses = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String response = this.writeSingle(key);
            responses.add(response);
        }
        return responses;
    }

    public void shutdown() throws Exception {
        this.graph.close();
        logger.info("JanusGraph DB shutdown");
    }

    public String getConnectionInfo() throws Exception {
        return super.getConnectionInfo(this.graph);
    }

    public String runWorkFlow() throws Exception {
        return null;
    }
}

