/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ndbench.plugin.janusgraph.cql;

import com.netflix.ndbench.plugin.janusgraph.IJanusGraphBuilder;
import com.netflix.ndbench.plugin.janusgraph.configs.IJanusGraphConfig;
import com.netflix.ndbench.plugin.janusgraph.configs.cql.ICQLConfig;
import java.net.Inet4Address;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.janusgraph.core.JanusGraphFactory;

@Singleton
public class JanusGraphBuilderCQLProvider
implements IJanusGraphBuilder {
    protected JanusGraphFactory.Builder graphBuilder;

    public JanusGraphBuilderCQLProvider() {
    }

    @Inject
    public JanusGraphBuilderCQLProvider(IJanusGraphConfig storageConfig, ICQLConfig config) {
        this.graphBuilder = JanusGraphFactory.build().set("storage.cql.keyspace", (Object)config.getKeyspace()).set("storage.backend", (Object)"cql").set("storage.cql.cluster-name", (Object)config.getClusterName()).set("storage.hostname", (Object)Optional.ofNullable(storageConfig.getStorageHostname()).orElse(Inet4Address.getLoopbackAddress().getHostAddress())).set("storage.port", (Object)storageConfig.getStoragePort()).set("storage.lock.wait-time", (Object)300).set("cache.db-cache", (Object)false).set("query.batch", (Object)false).set("query.smart-limit", (Object)false).set("query.force-index", (Object)false).set("query.fast-property", (Object)false);
    }

    @Override
    public JanusGraphFactory.Builder getGraphBuilder() {
        return this.graphBuilder;
    }
}

