/*
 * Decompiled with CFR 0.152.
 */
package netflix.ocelli.eureka;

import com.netflix.eureka2.client.Eureka;
import com.netflix.eureka2.client.EurekaClient;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.Interests;
import com.netflix.eureka2.registry.InstanceInfo;
import com.netflix.eureka2.registry.ServicePort;
import java.util.HashSet;
import netflix.ocelli.Host;
import netflix.ocelli.MembershipEvent;
import rx.Observable;
import rx.functions.Func1;

public class EurekaMembershipSource {
    private final EurekaClient client;
    private static final DefaultMapper defaultMapper = new DefaultMapper();

    public EurekaMembershipSource(ServerResolver eurekaResolver) {
        this.client = Eureka.newClient((ServerResolver)eurekaResolver);
    }

    public EurekaMembershipSource(EurekaClient client) {
        this.client = client;
    }

    public Observable<MembershipEvent<Host>> forVip(String ... vips) {
        return this.forInterest((Interest<InstanceInfo>)Interests.forVips((String[])vips));
    }

    public Observable<MembershipEvent<Host>> forInterest(Interest<InstanceInfo> interest) {
        return this.forInterest(interest, defaultMapper);
    }

    public Observable<MembershipEvent<Host>> forInterest(Interest<InstanceInfo> interest, final Func1<InstanceInfo, Host> instanceInfoToHost) {
        return this.client.forInterest(interest).flatMap((Func1)new Func1<ChangeNotification<InstanceInfo>, Observable<MembershipEvent<Host>>>(){

            public Observable<MembershipEvent<Host>> call(ChangeNotification<InstanceInfo> notification) {
                Host host = (Host)instanceInfoToHost.call(notification.getData());
                switch (notification.getKind()) {
                    case Add: {
                        return Observable.just((Object)new MembershipEvent(MembershipEvent.EventType.ADD, (Object)host));
                    }
                    case Delete: {
                        return Observable.just((Object)new MembershipEvent(MembershipEvent.EventType.REMOVE, (Object)host));
                    }
                    case Modify: {
                        return Observable.just((Object)new MembershipEvent(MembershipEvent.EventType.REMOVE, (Object)host), (Object)new MembershipEvent(MembershipEvent.EventType.ADD, (Object)host));
                    }
                }
                return Observable.empty();
            }
        });
    }

    protected static class DefaultMapper
    implements Func1<InstanceInfo, Host> {
        protected DefaultMapper() {
        }

        public Host call(InstanceInfo instanceInfo) {
            String ipAddress = instanceInfo.getDataCenterInfo().getDefaultAddress().getIpAddress();
            HashSet servicePorts = instanceInfo.getPorts();
            ServicePort portToUse = (ServicePort)servicePorts.iterator().next();
            return new Host(ipAddress, portToUse.getPort().intValue());
        }
    }
}

