/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.http.AmazonRxNettyHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.ServiceResult;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainRxNetty;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.services.cloudsearchdomain.model.SearchResult;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.services.cloudsearchdomain.model.SuggestResult;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsRequest;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsResult;
import com.amazonaws.services.cloudsearchdomain.model.transform.DocumentServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.SearchExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.SearchRequestMarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.SearchResultJsonUnmarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.SuggestRequestMarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.SuggestResultJsonUnmarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.UploadDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearchdomain.model.transform.UploadDocumentsResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;

public class AmazonCloudSearchDomainRxNettyClient
extends AmazonRxNettyHttpClient
implements AmazonCloudSearchDomainRxNetty {
    protected List<JsonErrorUnmarshaller> exceptionUnmarshallers;

    public AmazonCloudSearchDomainRxNettyClient() {
    }

    public AmazonCloudSearchDomainRxNettyClient(AWSCredentialsProvider aWSCredentialsProvider) {
        super(aWSCredentialsProvider);
    }

    public AmazonCloudSearchDomainRxNettyClient(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    public AmazonCloudSearchDomainRxNettyClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(aWSCredentialsProvider, clientConfiguration);
    }

    protected void init() {
        this.setEndpoint("cloudsearchdomain.us-east-1.amazonaws.com");
        this.exceptionUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new DocumentServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new SearchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
    }

    @Override
    public Observable<ServiceResult<SearchResult>> search(SearchRequest searchRequest) {
        return Observable.just((Object)searchRequest).flatMap(searchRequest2 -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)searchRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            return Observable.just((Object)0).map(n -> new SearchRequestMarshaller().marshall(searchRequest2)).flatMap(request -> {
                request.setAWSRequestMetrics(aWSRequestMetrics);
                SearchResultJsonUnmarshaller searchResultJsonUnmarshaller = SearchResultJsonUnmarshaller.getInstance();
                return this.invokeJson((Request)request, (Unmarshaller)searchResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext);
            }).map(searchResult -> new ServiceResult(l, searchResult));
        });
    }

    @Override
    public Observable<ServiceResult<SuggestResult>> suggest(SuggestRequest suggestRequest) {
        return Observable.just((Object)suggestRequest).flatMap(suggestRequest2 -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)suggestRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            return Observable.just((Object)0).map(n -> new SuggestRequestMarshaller().marshall(suggestRequest2)).flatMap(request -> {
                request.setAWSRequestMetrics(aWSRequestMetrics);
                SuggestResultJsonUnmarshaller suggestResultJsonUnmarshaller = SuggestResultJsonUnmarshaller.getInstance();
                return this.invokeJson((Request)request, (Unmarshaller)suggestResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext);
            }).map(suggestResult -> new ServiceResult(l, suggestResult));
        });
    }

    @Override
    public Observable<ServiceResult<UploadDocumentsResult>> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest) {
        return Observable.just((Object)uploadDocumentsRequest).flatMap(uploadDocumentsRequest2 -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)uploadDocumentsRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            return Observable.just((Object)0).map(n -> new UploadDocumentsRequestMarshaller().marshall(uploadDocumentsRequest2)).flatMap(request -> {
                request.setAWSRequestMetrics(aWSRequestMetrics);
                UploadDocumentsResultJsonUnmarshaller uploadDocumentsResultJsonUnmarshaller = UploadDocumentsResultJsonUnmarshaller.getInstance();
                return this.invokeJson((Request)request, (Unmarshaller)uploadDocumentsResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext);
            }).map(uploadDocumentsResult -> new ServiceResult(l, uploadDocumentsResult));
        });
    }
}

