/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.basicauth;

import com.networknt.basicauth.BasicAuthConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BasicAuthHandler.class);
    static final String CONFIG_NAME = "basic-auth";
    static final BasicAuthConfig config = (BasicAuthConfig)Config.getInstance().getJsonObjectConfig("basic-auth", BasicAuthConfig.class);
    static final String MISSING_AUTH_TOKEN = "ERR10002";
    static final String INVALID_BASIC_HEADER = "ERR10046";
    static final String INVALID_USERNAME_OR_PASSWORD = "ERR10047";
    private volatile HttpHandler next;

    public BasicAuthHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("BasicAuthHandler is loaded.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String auth = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        if (auth == null || auth.trim().length() == 0) {
            this.setExchangeStatus(exchange, MISSING_AUTH_TOKEN, new Object[0]);
            return;
        }
        String basic = auth.substring(0, 5);
        if (!"BASIC".equalsIgnoreCase(basic)) {
            this.setExchangeStatus(exchange, INVALID_BASIC_HEADER, new Object[]{auth});
            return;
        }
        String credentials = auth.substring(6);
        int pos = credentials.indexOf(58);
        if (pos == -1) {
            credentials = new String(Base64.decodeBase64((String)credentials), StandardCharsets.UTF_8);
        }
        if ((pos = credentials.indexOf(58)) == -1) {
            this.setExchangeStatus(exchange, INVALID_BASIC_HEADER, new Object[]{auth});
            return;
        }
        String username = credentials.substring(0, pos);
        String password = credentials.substring(pos + 1);
        Optional<Map> result = config.getUsers().stream().filter(user -> user.get("username").equals(username) && user.get("password").equals(password)).findFirst();
        if (!result.isPresent()) {
            this.setExchangeStatus(exchange, INVALID_USERNAME_OR_PASSWORD, new Object[0]);
            return;
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ArrayList<String> masks = new ArrayList<String>();
        masks.add("password");
        ModuleRegistry.registerModule((String)BasicAuthHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
    }
}

