/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.networknt.cache.CacheConfig;
import com.networknt.cache.CacheItem;
import com.networknt.cache.CaffeineCacheManager;
import com.networknt.service.SingletonServiceFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager {
    public static final Logger logger = LoggerFactory.getLogger(CacheManager.class);

    public static CacheManager getInstance() {
        List<CacheItem> caches = CacheConfig.load().getCaches();
        if (caches != null && caches.size() > 0) {
            CacheManager cacheManager = (CacheManager)SingletonServiceFactory.getBean(CacheManager.class);
            if (cacheManager == null) {
                logger.warn("No cache manager configured in service.yml; default to CaffeineCacheManager");
                cacheManager = new CaffeineCacheManager();
                for (CacheItem cacheItem : CacheConfig.load().getCaches()) {
                    cacheManager.addCache(cacheItem.getCacheName(), cacheItem.getMaxSize(), cacheItem.getExpiryInMinutes());
                }
                SingletonServiceFactory.setBean((String)CacheManager.class.getName(), (Object)cacheManager);
            }
            return cacheManager;
        }
        return null;
    }

    public void addCache(String var1, long var2, long var4);

    public Cache<Object, Object> getCache(String var1);

    public void removeCache(String var1);
}

