/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.cache.CacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheManager
implements CacheManager {
    private final Map<String, Cache<Object, Object>> caches = new ConcurrentHashMap<String, Cache<Object, Object>>();

    @Override
    public void addCache(String cacheName, long maximumSize, long expiryInMinutes) {
        Cache cache = Caffeine.newBuilder().maximumSize(maximumSize).expireAfterWrite(expiryInMinutes, TimeUnit.MINUTES).build();
        this.caches.put(cacheName, (Cache<Object, Object>)cache);
    }

    @Override
    public Cache<Object, Object> getCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    @Override
    public void removeCache(String cacheName) {
        Cache<Object, Object> cache = this.caches.get(cacheName);
        if (cache != null) {
            cache.invalidateAll();
            this.caches.remove(cacheName);
        }
    }
}

