/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConfig {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfig.class);
    public static final String CONFIG_NAME = "client";
    public static final String REQUEST = "request";
    public static final String SERVER_URL = "server_url";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String SERVICE_ID = "serviceId";
    public static final String URI = "uri";
    public static final String TLS = "tls";
    public static final String CLIENT_ID = "client_id";
    public static final String SCOPE = "scope";
    public static final String AUDIENCE = "audience";
    public static final String CSRF = "csrf";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String SAML_BEARER = "saml_bearer";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String CLIENT_AUTHENTICATED_USER = "client_authenticated_user";
    public static final String CACHE = "cache";
    public static final String CAPACITY = "capacity";
    public static final String OAUTH = "oauth";
    public static final String MULTIPLE_AUTH_SERVERS = "multipleAuthServers";
    public static final String PATH_PREFIX_SERVICES = "pathPrefixServices";
    public static final String SERVICE_ID_AUTH_SERVERS = "serviceIdAuthServers";
    public static final String KEY = "key";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String ENABLE_HTTP2 = "enableHttp2";
    public static final String TIMEOUT = "timeout";
    public static final String TOKEN = "token";
    public static final int DEFAULT_BUFFER_SIZE = 24;
    public static final int DEFAULT_ERROR_THRESHOLD = 5;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RESET_TIMEOUT = 600000;
    public static final boolean DEFAULT_INJECT_OPEN_TRACING = false;
    public static final boolean DEFAULT_INJECT_CALLER_ID = false;
    private static final String ERROR_THRESHOLD = "errorThreshold";
    private static final String RESET_TIMEOUT = "resetTimeout";
    private static final String INJECT_OPEN_TRACING = "injectOpenTracing";
    private static final String INJECT_CALLER_ID = "injectCallerId";
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 1000;
    public static final boolean DEFAULT_REQUEST_ENABLE_HTTP2 = true;
    public static final int DEFAULT_MAX_REQUEST_PER_CONNECTION = 1000000;
    public static final long DEFAULT_CONNECTION_EXPIRE_TIME = 1000000L;
    public static final int DEFAULT_MAX_CONNECTION_PER_HOST = 1000;
    public static final int DEFAULT_MIN_CONNECTION_PER_HOST = 250;
    public static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    public static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    public static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    private static final String CONNECTION_POOL_SIZE = "connectionPoolSize";
    private static final String MAX_REQUEST_PER_CONNECTION = "maxReqPerConn";
    private static final String CONNECTION_EXPIRE_TIME = "connectionExpireTime";
    private static final String MAX_CONNECTION_NUM_PER_HOST = "maxConnectionNumPerHost";
    private static final String MIN_CONNECTION_NUM_PER_HOST = "minConnectionNumPerHost";
    public static final String DEREF = "deref";
    public static final String SIGN = "sign";
    private int resetTimeout = 600000;
    private int timeout = 3000;
    private int errorThreshold = 5;
    private boolean injectOpenTracing = false;
    private boolean injectCallerId = false;
    private int connectionPoolSize = 1000;
    private int maxReqPerConn = 1000000;
    private boolean requestEnableHttp2 = true;
    private long connectionExpireTime = 1000000L;
    private int maxConnectionNumPerHost = 1000;
    private int minConnectionNumPerHost = 250;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;
    private Map<String, Object> tlsConfig;
    private boolean multipleAuthServers;
    private Map<String, Object> oauthConfig;
    private Map<String, Object> tokenConfig;
    private Map<String, Object> derefConfig;
    private Map<String, Object> signConfig;
    private Map<String, String> pathPrefixServices;
    private static volatile ClientConfig instance;

    private ClientConfig() {
        this.mappedConfig = this.config.getJsonMapConfig(CONFIG_NAME);
        this.load();
    }

    private ClientConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.load();
    }

    private void load() {
        if (this.mappedConfig != null) {
            this.setRequestConfig();
            this.setTlsConfig();
            this.setOAuthConfig();
            if (this.multipleAuthServers) {
                this.setPathPrefixServices();
            }
        }
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        if (this.mappedConfig != null) {
            this.setRequestConfig();
            this.setTlsConfig();
            this.setOAuthConfig();
            if (this.multipleAuthServers) {
                this.setPathPrefixServices();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientConfig get() {
        if (instance != null) return instance;
        Class<ClientConfig> clazz = ClientConfig.class;
        synchronized (ClientConfig.class) {
            if (instance != null) return instance;
            instance = new ClientConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ClientConfig get(String configName) {
        instance = new ClientConfig(configName);
        return instance;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setTlsConfig() {
        this.tlsConfig = (Map)this.mappedConfig.get(TLS);
    }

    public Map<String, Object> getTlsConfig() {
        return this.tlsConfig;
    }

    private void setRequestConfig() {
        if (!this.mappedConfig.containsKey(REQUEST)) {
            return;
        }
        Map requestConfig = (Map)this.mappedConfig.get(REQUEST);
        Object object = requestConfig.get(ERROR_THRESHOLD);
        if (object != null) {
            this.errorThreshold = Config.loadIntegerValue((String)ERROR_THRESHOLD, object);
        }
        if ((object = requestConfig.get(TIMEOUT)) != null) {
            this.timeout = Config.loadIntegerValue((String)TIMEOUT, object);
        }
        if ((object = requestConfig.get(RESET_TIMEOUT)) != null) {
            this.resetTimeout = Config.loadIntegerValue((String)RESET_TIMEOUT, object);
        }
        if ((object = requestConfig.get(INJECT_OPEN_TRACING)) != null) {
            this.injectOpenTracing = Config.loadBooleanValue((String)INJECT_OPEN_TRACING, object);
        }
        if ((object = requestConfig.get(INJECT_CALLER_ID)) != null) {
            this.injectCallerId = Config.loadBooleanValue((String)INJECT_CALLER_ID, object);
        }
        if ((object = requestConfig.get(ENABLE_HTTP2)) != null) {
            this.requestEnableHttp2 = Config.loadBooleanValue((String)ENABLE_HTTP2, object);
        }
        if ((object = requestConfig.get(CONNECTION_POOL_SIZE)) != null) {
            this.connectionPoolSize = Config.loadIntegerValue((String)CONNECTION_POOL_SIZE, object);
        }
        if ((object = requestConfig.get(CONNECTION_EXPIRE_TIME)) != null) {
            this.connectionExpireTime = Config.loadLongValue((String)CONNECTION_EXPIRE_TIME, object);
        }
        if ((object = requestConfig.get(MAX_REQUEST_PER_CONNECTION)) != null) {
            this.maxReqPerConn = Config.loadIntegerValue((String)MAX_REQUEST_PER_CONNECTION, object);
        }
        if ((object = requestConfig.get(MAX_CONNECTION_NUM_PER_HOST)) != null) {
            this.maxConnectionNumPerHost = Config.loadIntegerValue((String)MAX_CONNECTION_NUM_PER_HOST, object);
        }
        if ((object = requestConfig.get(MIN_CONNECTION_NUM_PER_HOST)) != null) {
            this.minConnectionNumPerHost = Config.loadIntegerValue((String)MIN_CONNECTION_NUM_PER_HOST, object);
        }
    }

    private void setPathPrefixServices() {
        if (this.mappedConfig.get(PATH_PREFIX_SERVICES) != null && this.mappedConfig.get(PATH_PREFIX_SERVICES) instanceof Map) {
            this.pathPrefixServices = (Map)this.mappedConfig.get(PATH_PREFIX_SERVICES);
        }
    }

    public Map<String, String> getPathPrefixServices() {
        return this.pathPrefixServices;
    }

    public static Map<String, Object> getServiceIdAuthServers(Object object) {
        Map serviceIdAuthServers = new HashMap();
        if (object instanceof Map) {
            serviceIdAuthServers = (Map)object;
        } else if (object instanceof String) {
            String s = (String)object;
            if ((s = s.trim()).startsWith("{")) {
                serviceIdAuthServers = JsonMapper.string2Map((String)s);
            } else {
                logger.error("The serviceIdAuthServers in client.yml is not a map or a JSON string.");
            }
        } else {
            logger.error("The serviceIdAuthServers in client.yml is not a map or a JSON string.");
        }
        return serviceIdAuthServers;
    }

    private void setOAuthConfig() {
        this.oauthConfig = (Map)this.mappedConfig.get(OAUTH);
        if (this.oauthConfig != null) {
            this.tokenConfig = (Map)this.oauthConfig.get(TOKEN);
            this.derefConfig = (Map)this.oauthConfig.get(DEREF);
            this.signConfig = (Map)this.oauthConfig.get(SIGN);
            this.multipleAuthServers = this.oauthConfig.get(MULTIPLE_AUTH_SERVERS) != null ? Config.loadBooleanValue((String)MULTIPLE_AUTH_SERVERS, (Object)this.oauthConfig.get(MULTIPLE_AUTH_SERVERS)) : false;
        }
    }

    public Map<String, Object> getOauthConfig() {
        return this.oauthConfig;
    }

    public Map<String, Object> getTokenConfig() {
        return this.tokenConfig;
    }

    public Map<String, Object> getDerefConfig() {
        return this.derefConfig;
    }

    public Map<String, Object> getSignConfig() {
        return this.signConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResetTimeout() {
        return this.resetTimeout;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public boolean isInjectOpenTracing() {
        return this.injectOpenTracing;
    }

    public boolean isInjectCallerId() {
        return this.injectCallerId;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getMaxRequestPerConnection() {
        return this.maxReqPerConn;
    }

    public boolean getRequestEnableHttp2() {
        return this.requestEnableHttp2;
    }

    public void setRequestEnableHttp2(boolean requestEnableHttp2) {
        this.requestEnableHttp2 = requestEnableHttp2;
    }

    public long getConnectionExpireTime() {
        return this.connectionExpireTime;
    }

    public int getMaxConnectionNumPerHost() {
        return this.maxConnectionNumPerHost;
    }

    public int getMinConnectionNumPerHost() {
        return this.minConnectionNumPerHost;
    }

    public boolean isMultipleAuthServers() {
        return this.multipleAuthServers;
    }

    public int getBufferSize() {
        return 24;
    }
}

