/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.config.Config;
import java.util.Map;

public final class ClientConfig {
    public static final String CONFIG_NAME = "client";
    public static final String CONFIG_SECRET = "secret";
    public static final String REQUEST = "request";
    public static final String SERVER_URL = "server_url";
    public static final String SERVICE_ID = "serviceId";
    public static final String URI = "uri";
    public static final String CLIENT_ID = "client_id";
    public static final String SCOPE = "scope";
    public static final String CSRF = "csrf";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String SAML_BEARER = "saml_bearer";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String CACHE = "cache";
    public static final String CAPACITY = "capacity";
    public static final String CLIENT_CONFIG_NAME = "client";
    public static final String OAUTH = "oauth";
    public static final String KEY = "key";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String DEREF = "deref";
    public static final String SIGN = "sign";
    public static final String ENABLE_HTTP2 = "enableHttp2";
    public static final String TIMEOUT = "timeout";
    public static final String TOKEN = "token";
    public static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    public static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    public static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    public static final int DEFAULT_BUFFER_SIZE = 24;
    public static final int DEFAULT_ERROR_THRESHOLD = 5;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RESET_TIMEOUT = 600000;
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 1000;
    public static final boolean DEFAULT_REQUEST_ENABLE_HTTP2 = true;
    public static final int DEFAULT_MAX_REQUEST_PER_CONNECTION = 1000000;
    public static final long DEFAULT_CONNECTION_EXPIRE_TIME = 1000000L;
    public static final int DEFAULT_MAX_CONNECTION_PER_HOST = 1000;
    public static final int DEFAULT_MIN_CONNECTION_PER_HOST = 250;
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String ERROR_THRESHOLD = "errorThreshold";
    private static final String RESET_TIMEOUT = "resetTimeout";
    private static final String CONNECTION_POOL_SIZE = "connectionPoolSize";
    private static final String MAX_REQUEST_PER_CONNECTION = "maxReqPerConn";
    private static final String CONNECTION_EXPIRE_TIME = "connectionExpireTime";
    private static final String MAX_CONNECTION_NUM_PER_HOST = "maxConnectionNumPerHost";
    private static final String MIN_CONNECTION_NUM_PER_HOST = "minConnectionNumPerHost";
    private final Config config = Config.getInstance();
    private final Map<String, Object> mappedConfig = this.config.getJsonMapConfig("client");
    private Map<String, Object> tokenConfig;
    private Map<String, Object> secretConfig;
    private Map<String, Object> derefConfig;
    private Map<String, Object> signConfig;
    private int bufferSize = 24;
    private int resetTimeout = 600000;
    private int timeout = 3000;
    private int errorThreshold = 5;
    private int connectionPoolSize = 1000;
    private int maxReqPerConn = 1000000;
    private boolean requestEnableHttp2 = true;
    private long connectionExpireTime = 1000000L;
    private int maxConnectionNumPerHost = 1000;
    private int minConnectionNumPerHost = 250;
    private static ClientConfig instance;

    private ClientConfig() {
        if (this.mappedConfig != null) {
            this.setBufferSize();
            this.setTokenConfig();
            this.setSecretConfig();
            this.setRequestConfig();
            this.setDerefConfig();
            this.setSignConfig();
        }
    }

    public static ClientConfig get() {
        if (instance == null) {
            instance = new ClientConfig();
        }
        return instance;
    }

    static void reset() {
        instance = null;
    }

    private void setSecretConfig() {
        this.secretConfig = Config.getInstance().getJsonMapConfig(CONFIG_SECRET);
    }

    private void setRequestConfig() {
        if (!this.mappedConfig.containsKey(REQUEST)) {
            return;
        }
        Map requestConfig = (Map)this.mappedConfig.get(REQUEST);
        if (requestConfig.containsKey(RESET_TIMEOUT)) {
            this.resetTimeout = (Integer)requestConfig.get(RESET_TIMEOUT);
        }
        if (requestConfig.containsKey(ERROR_THRESHOLD)) {
            this.errorThreshold = (Integer)requestConfig.get(ERROR_THRESHOLD);
        }
        if (requestConfig.containsKey(TIMEOUT)) {
            this.timeout = (Integer)requestConfig.get(TIMEOUT);
        }
        if (requestConfig.containsKey(CONNECTION_POOL_SIZE)) {
            this.connectionPoolSize = (Integer)requestConfig.get(CONNECTION_POOL_SIZE);
        }
        if (requestConfig.containsKey(ENABLE_HTTP2)) {
            this.requestEnableHttp2 = (Boolean)requestConfig.get(ENABLE_HTTP2);
        }
        if (requestConfig.containsKey(MAX_REQUEST_PER_CONNECTION)) {
            this.maxReqPerConn = (Integer)requestConfig.get(MAX_REQUEST_PER_CONNECTION);
        }
        if (requestConfig.containsKey(CONNECTION_EXPIRE_TIME)) {
            this.connectionExpireTime = Long.parseLong(requestConfig.get(CONNECTION_EXPIRE_TIME).toString());
        }
        if (requestConfig.containsKey(MAX_CONNECTION_NUM_PER_HOST)) {
            this.maxConnectionNumPerHost = (Integer)requestConfig.get(MAX_CONNECTION_NUM_PER_HOST);
        }
        if (requestConfig.containsKey(MIN_CONNECTION_NUM_PER_HOST)) {
            this.minConnectionNumPerHost = (Integer)requestConfig.get(MIN_CONNECTION_NUM_PER_HOST);
        }
    }

    private void setBufferSize() {
        Object bufferSizeObject = this.mappedConfig.get(BUFFER_SIZE);
        if (bufferSizeObject != null) {
            this.bufferSize = (Integer)bufferSizeObject;
        }
    }

    private void setTokenConfig() {
        Map oauthConfig = (Map)this.mappedConfig.get(OAUTH);
        if (oauthConfig != null) {
            this.tokenConfig = (Map)oauthConfig.get(TOKEN);
        }
    }

    private void setDerefConfig() {
        Map oauthConfig = (Map)this.mappedConfig.get(OAUTH);
        if (oauthConfig != null) {
            this.derefConfig = (Map)oauthConfig.get(DEREF);
        }
    }

    private void setSignConfig() {
        Map oauthConfig = (Map)this.mappedConfig.get(OAUTH);
        if (oauthConfig != null) {
            this.signConfig = (Map)oauthConfig.get(SIGN);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Config getConfig() {
        return this.config;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public Map<String, Object> getTokenConfig() {
        return this.tokenConfig;
    }

    public Map<String, Object> getSecretConfig() {
        return this.secretConfig;
    }

    public Map<String, Object> getDerefConfig() {
        return this.derefConfig;
    }

    public Map<String, Object> getSignConfig() {
        return this.signConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResetTimeout() {
        return this.resetTimeout;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean getRequestEnableHttp2() {
        return this.requestEnableHttp2;
    }

    public int getMaxRequestPerConnection() {
        return this.maxReqPerConn;
    }

    protected void setRequestEnableHttp2(boolean isRequestEnableHttp2) {
        this.requestEnableHttp2 = isRequestEnableHttp2;
    }

    public long getConnectionExpireTime() {
        return this.connectionExpireTime;
    }

    public int getMaxConnectionNumPerHost() {
        return this.maxConnectionNumPerHost;
    }

    public int getMinConnectionNumPerHost() {
        return this.minConnectionNumPerHost;
    }
}

