/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.Http2Client;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientResponse;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientCompletableFutureWithRequest
extends CompletableFuture<ClientResponse>
implements ClientCallback<ClientExchange> {
    private Logger logger = LoggerFactory.getLogger(Http2ClientCompletableFutureWithRequest.class);
    private String requestBody;

    public Http2ClientCompletableFutureWithRequest(String requestBody) {
        this.requestBody = requestBody;
    }

    public void completed(ClientExchange result) {
        new StringWriteChannelListener(this.requestBody).setup(result.getRequestChannel());
        result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

            public void completed(final ClientExchange result) {
                new StringReadChannelListener(Http2Client.BUFFER_POOL){

                    protected void stringDone(String string) {
                        if (Http2ClientCompletableFutureWithRequest.this.logger.isDebugEnabled()) {
                            Http2ClientCompletableFutureWithRequest.this.logger.debug("Service call response = {}", (Object)string);
                        }
                        result.getResponse().putAttachment(Http2Client.RESPONSE_BODY, (Object)string);
                        Http2ClientCompletableFutureWithRequest.this.complete(result.getResponse());
                    }

                    protected void error(IOException e) {
                        Http2ClientCompletableFutureWithRequest.this.logger.error("IOException:", (Throwable)e);
                        Http2ClientCompletableFutureWithRequest.this.completeExceptionally(e);
                    }
                }.setup(result.getResponseChannel());
            }

            public void failed(IOException e) {
                Http2ClientCompletableFutureWithRequest.this.logger.error("IOException:", (Throwable)e);
                Http2ClientCompletableFutureWithRequest.this.completeExceptionally(e);
            }
        });
    }

    public void failed(IOException e) {
        this.logger.error("IOException:", (Throwable)e);
        this.completeExceptionally(e);
    }
}

