/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.networknt.client.Http2Client;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.ClientRequestComposerProvider;
import com.networknt.client.oauth.DerefRequest;
import com.networknt.client.oauth.IClientRequestComposable;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.RefreshTokenRequest;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.SignRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.httpstring.ContentType;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;

public class OauthHelper {
    private static final String BASIC = "Basic";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CODE = "code";
    @Deprecated
    static final String SCOPE = "scope";
    @Deprecated
    static final String SERVICE_ID = "service_id";
    private static final String FAIL_TO_SEND_REQUEST = "ERR10051";
    private static final String GET_TOKEN_ERROR = "ERR10052";
    private static final String ESTABLISH_CONNECTION_ERROR = "ERR10053";
    private static final String GET_TOKEN_TIMEOUT = "ERR10054";
    public static final String STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    private static final Logger logger = LoggerFactory.getLogger(OauthHelper.class);

    @Deprecated
    public static TokenResponse getToken(TokenRequest tokenRequest) throws ClientException {
        Result<TokenResponse> responseResult = OauthHelper.getTokenResult(tokenRequest);
        if (responseResult.isSuccess()) {
            return (TokenResponse)((Object)responseResult.getResult());
        }
        throw new ClientException(responseResult.getError());
    }

    public static Result<TokenResponse> getTokenResult(TokenRequest tokenRequest) {
        return OauthHelper.getTokenResult(tokenRequest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<TokenResponse> getTokenResult(TokenRequest tokenRequest, String envTag) {
        ClientConnection connection;
        CountDownLatch latch;
        AtomicReference<Result<TokenResponse>> reference;
        block9: {
            reference = new AtomicReference<Result<TokenResponse>>();
            Http2Client client = Http2Client.getInstance();
            latch = new CountDownLatch(1);
            try {
                if (tokenRequest.getServerUrl() != null) {
                    connection = (ClientConnection)client.connect(new URI(tokenRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, tokenRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                if (tokenRequest.getServiceId() != null) {
                    Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
                    String url = cluster.serviceToUrl("https", tokenRequest.getServiceId(), envTag, null);
                    connection = (ClientConnection)client.connect(new URI(url), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, tokenRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                logger.error("Error: both server_url and serviceId are not configured in client.yml for " + tokenRequest.getClass());
                throw new ClientException("both server_url and serviceId are not configured in client.yml for " + tokenRequest.getClass());
            }
            catch (Exception e) {
                logger.error("cannot establish connection:", (Throwable)e);
                return Failure.of((Status)new Status(ESTABLISH_CONNECTION_ERROR, new Object[]{tokenRequest.getServerUrl() != null ? tokenRequest.getServerUrl() : tokenRequest.getServiceId()}));
            }
        }
        try {
            IClientRequestComposable requestComposer = ClientRequestComposerProvider.getInstance().getComposer(ClientRequestComposerProvider.ClientRequestComposers.CLIENT_CREDENTIAL_REQUEST_COMPOSER);
            connection.getIoThread().execute((Runnable)new TokenRequestAction(tokenRequest, requestComposer, connection, reference, latch));
            latch.await(4L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("IOException: ", (Throwable)e);
            Result result = Failure.of((Status)new Status(FAIL_TO_SEND_REQUEST, new Object[0]));
            return result;
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get() == null ? Failure.of((Status)new Status(GET_TOKEN_TIMEOUT, new Object[0])) : reference.get();
    }

    public static Result<TokenResponse> getSignResult(SignRequest signRequest) {
        return OauthHelper.getSignResult(signRequest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<TokenResponse> getSignResult(SignRequest signRequest, String envTag) {
        ClientConnection connection;
        CountDownLatch latch;
        AtomicReference reference;
        block9: {
            reference = new AtomicReference();
            Http2Client client = Http2Client.getInstance();
            latch = new CountDownLatch(1);
            try {
                if (signRequest.getServerUrl() != null) {
                    connection = (ClientConnection)client.connect(new URI(signRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, signRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                if (signRequest.getServiceId() != null) {
                    Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
                    String url = cluster.serviceToUrl("https", signRequest.getServiceId(), envTag, null);
                    connection = (ClientConnection)client.connect(new URI(url), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, signRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                logger.error("Error: both server_url and serviceId are not configured in client.yml for " + signRequest.getClass());
                throw new ClientException("both server_url and serviceId are not configured in client.yml for " + signRequest.getClass());
            }
            catch (Exception e) {
                logger.error("cannot establish connection:", (Throwable)e);
                return Failure.of((Status)new Status(ESTABLISH_CONNECTION_ERROR, new Object[]{signRequest.getServerUrl() != null ? signRequest.getServerUrl() : signRequest.getServiceId()}));
            }
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expires", signRequest.getExpires());
            map.put("payload", signRequest.getPayload());
            final String requestBody = Config.getInstance().getMapper().writeValueAsString(map);
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(signRequest.getUri());
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-www-form-urlencoded");
                request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(signRequest.getClientId(), signRequest.getClientSecret()));
                connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(ClientExchange result) {
                        new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                        result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(final ClientExchange result) {
                                new StringReadChannelListener(Http2Client.BUFFER_POOL){

                                    protected void stringDone(String string) {
                                        logger.debug("getToken response = " + string);
                                        reference.set(OauthHelper.handleResponse(OauthHelper.getContentTypeFromExchange(result), string));
                                        latch.countDown();
                                    }

                                    protected void error(IOException e) {
                                        logger.error("IOException:", (Throwable)e);
                                        reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                        latch.countDown();
                                    }
                                }.setup(result.getResponseChannel());
                            }

                            public void failed(IOException e) {
                                logger.error("IOException:", (Throwable)e);
                                reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                latch.countDown();
                            }
                        });
                    }

                    public void failed(IOException e) {
                        logger.error("IOException:", (Throwable)e);
                        reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                        latch.countDown();
                    }
                });
            });
            latch.await(signRequest.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("IOException: ", (Throwable)e);
            Result result = Failure.of((Status)new Status(FAIL_TO_SEND_REQUEST, new Object[0]));
            return result;
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get() == null ? Failure.of((Status)new Status(GET_TOKEN_TIMEOUT, new Object[0])) : (Result)reference.get();
    }

    @Deprecated
    public static TokenResponse getTokenFromSaml(SAMLBearerRequest tokenRequest) throws ClientException {
        Result<TokenResponse> responseResult = OauthHelper.getTokenFromSamlResult(tokenRequest);
        if (responseResult.isSuccess()) {
            return (TokenResponse)((Object)responseResult.getResult());
        }
        throw new ClientException(responseResult.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<TokenResponse> getTokenFromSamlResult(SAMLBearerRequest tokenRequest) {
        ClientConnection connection;
        AtomicReference<Result<TokenResponse>> reference = new AtomicReference<Result<TokenResponse>>();
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = (ClientConnection)client.connect(new URI(tokenRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, tokenRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
        }
        catch (Exception e) {
            logger.error("cannot establish connection:", (Throwable)e);
            return Failure.of((Status)new Status(ESTABLISH_CONNECTION_ERROR, new Object[0]));
        }
        try {
            IClientRequestComposable requestComposer = ClientRequestComposerProvider.getInstance().getComposer(ClientRequestComposerProvider.ClientRequestComposers.SAML_BEARER_REQUEST_COMPOSER);
            connection.getIoThread().execute((Runnable)new TokenRequestAction(tokenRequest, requestComposer, connection, reference, latch));
            latch.await(4L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("IOException: ", (Throwable)e);
            Result result = Failure.of((Status)new Status(FAIL_TO_SEND_REQUEST, new Object[0]));
            return result;
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get() == null ? Failure.of((Status)new Status(GET_TOKEN_TIMEOUT, new Object[0])) : reference.get();
    }

    public static String getKey(KeyRequest keyRequest) throws ClientException {
        return OauthHelper.getKey(keyRequest, null);
    }

    public static String getKey(KeyRequest keyRequest, String envTag) throws ClientException {
        ClientConnection connection;
        CountDownLatch latch;
        Http2Client client;
        block10: {
            client = Http2Client.getInstance();
            latch = new CountDownLatch(1);
            try {
                if (keyRequest.getServerUrl() != null) {
                    connection = (ClientConnection)client.connect(new URI(keyRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, keyRequest.enableHttp2 ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block10;
                }
                if (keyRequest.getServiceId() != null) {
                    Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
                    String url = cluster.serviceToUrl("https", keyRequest.getServiceId(), envTag, null);
                    connection = (ClientConnection)client.connect(new URI(url), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, keyRequest.enableHttp2 ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block10;
                }
                logger.error("Error: both server_url and serviceId are not configured in client.yml for " + keyRequest.getClass());
                throw new ClientException("both server_url and serviceId are not configured in client.yml for " + keyRequest.getClass());
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            ClientRequest request = new ClientRequest().setPath(keyRequest.getUri()).setMethod(Methods.GET);
            if (keyRequest.getClientId() != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(keyRequest.getClientId(), keyRequest.getClientSecret()));
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            OauthHelper.adjustNoChunkedEncoding(request, "");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return (String)reference.get().getAttachment(Http2Client.RESPONSE_BODY);
    }

    public static String derefToken(DerefRequest derefRequest) throws ClientException {
        return OauthHelper.derefToken(derefRequest, null);
    }

    public static String derefToken(DerefRequest derefRequest, String envTag) throws ClientException {
        ClientConnection connection;
        CountDownLatch latch;
        Http2Client client;
        block9: {
            client = Http2Client.getInstance();
            latch = new CountDownLatch(1);
            try {
                if (derefRequest.getServerUrl() != null) {
                    connection = (ClientConnection)client.connect(new URI(derefRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, derefRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                if (derefRequest.getServiceId() != null) {
                    Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
                    String url = cluster.serviceToUrl("https", derefRequest.getServiceId(), envTag, null);
                    connection = (ClientConnection)client.connect(new URI(url), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, derefRequest.isEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY).get();
                    break block9;
                }
                logger.error("Error: both server_url and serviceId are not configured in client.yml for " + derefRequest.getClass());
                throw new ClientException("both server_url and serviceId are not configured in client.yml for " + derefRequest.getClass());
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                throw new ClientException((Throwable)e);
            }
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            ClientRequest request = new ClientRequest().setPath(derefRequest.getUri()).setMethod(Methods.GET);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(derefRequest.getClientId(), derefRequest.getClientSecret()));
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return (String)reference.get().getAttachment(Http2Client.RESPONSE_BODY);
    }

    public static String getBasicAuthHeader(String clientId, String clientSecret) {
        return "Basic " + OauthHelper.encodeCredentials(clientId, clientSecret);
    }

    public static String encodeCredentials(String clientId, String clientSecret) {
        String cred = clientSecret != null ? clientId + ":" + clientSecret : clientId;
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes(StandardCharsets.UTF_8));
        String encodedValue = new String(encodedBytes, StandardCharsets.UTF_8);
        return encodedValue;
    }

    public static String getEncodedString(TokenRequest request) throws UnsupportedEncodingException {
        String csrf;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE, request.getGrantType());
        if (TokenRequest.AUTHORIZATION_CODE.equals(request.getGrantType())) {
            params.put(CODE, ((AuthorizationCodeRequest)request).getAuthCode());
            if (((AuthorizationCodeRequest)request).getRedirectUri() != null) {
                params.put(TokenRequest.REDIRECT_URI, ((AuthorizationCodeRequest)request).getRedirectUri());
            }
            if ((csrf = request.getCsrf()) != null) {
                params.put(TokenRequest.CSRF, csrf);
            }
        }
        if (TokenRequest.REFRESH_TOKEN.equals(request.getGrantType())) {
            params.put(TokenRequest.REFRESH_TOKEN, ((RefreshTokenRequest)request).getRefreshToken());
            csrf = request.getCsrf();
            if (csrf != null) {
                params.put(TokenRequest.CSRF, csrf);
            }
        }
        if (request.getScope() != null) {
            params.put(SCOPE, String.join((CharSequence)" ", request.getScope()));
        }
        return Http2Client.getFormDataString(params);
    }

    private static Result<TokenResponse> handleResponse(ContentType contentType, String responseBody) {
        Result result;
        try {
            if (!contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                return Failure.of((Status)new Status(GET_TOKEN_ERROR, new Object[]{OauthHelper.escapeBasedOnType(contentType, responseBody)}));
            }
            if (responseBody != null && responseBody.length() > 0) {
                TokenResponse tokenResponse = (TokenResponse)((Object)Config.getInstance().getMapper().readValue(responseBody, TokenResponse.class));
                result = tokenResponse != null && tokenResponse.getAccessToken() != null ? Success.of((Object)((Object)tokenResponse)) : Failure.of((Status)new Status(tokenResponse.getStatusCode(), tokenResponse.getCode(), tokenResponse.getMessage(), tokenResponse.getDescription(), tokenResponse.getSeverity()));
            } else {
                result = Failure.of((Status)new Status(GET_TOKEN_ERROR, new Object[]{"no auth server response"}));
                logger.error("Error in token retrieval, response = " + responseBody);
            }
        }
        catch (UnrecognizedPropertyException e) {
            result = Failure.of((Status)new Status(GET_TOKEN_ERROR, new Object[]{OauthHelper.escapeBasedOnType(contentType, responseBody)}));
        }
        catch (IOException | RuntimeException e) {
            result = Failure.of((Status)new Status(GET_TOKEN_ERROR, new Object[]{e.getMessage()}));
            logger.error("Error in token retrieval", (Throwable)e);
        }
        return result;
    }

    @Deprecated
    public static void sendStatusToResponse(HttpServerExchange exchange, Status status) {
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(status.toString());
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<Jwt> populateCCToken(Jwt jwt) {
        boolean isInRenewWindow = jwt.getExpire() - System.currentTimeMillis() < Jwt.getTokenRenewBeforeExpired();
        logger.trace("isInRenewWindow = " + isInRenewWindow);
        if (!isInRenewWindow) {
            return Success.of((Object)jwt);
        }
        Jwt jwt2 = jwt;
        synchronized (jwt2) {
            if (jwt.getExpire() <= System.currentTimeMillis()) {
                Result<Jwt> result = OauthHelper.renewCCTokenSync(jwt);
                if (logger.isTraceEnabled()) {
                    logger.trace("Check secondary token is done!");
                }
                return result;
            }
            OauthHelper.renewCCTokenAsync(jwt);
            if (logger.isTraceEnabled()) {
                logger.trace("Check secondary token is done!");
            }
            return Success.of((Object)jwt);
        }
    }

    private static Result<Jwt> renewCCTokenSync(Jwt jwt) {
        logger.trace("In renew window and token is already expired.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getExpiredRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + Jwt.getExpiredRefreshRetryDelay());
            Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
            jwt.setRenewing(false);
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Circuit breaker is tripped and not timeout yet!");
        }
        return Failure.of((Status)new Status(STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE, new Object[0]));
    }

    private static void renewCCTokenAsync(Jwt jwt) {
        logger.trace("In renew window but token is not expired yet.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getEarlyRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + Jwt.getEarlyRefreshRetryDelay());
            logger.trace("Retrieve token async is called while token is not expired yet");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.schedule(() -> {
                Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
                if (result.isFailure()) {
                    logger.error("Async retrieve token error with status: {}", (Object)result.getError().toString());
                }
                jwt.setRenewing(false);
            }, 50L, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
    }

    private static Result<Jwt> getCCTokenRemotely(Jwt jwt) {
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        OauthHelper.setScope(tokenRequest, jwt);
        Result<TokenResponse> result = OauthHelper.getTokenResult(tokenRequest);
        if (result.isSuccess()) {
            TokenResponse tokenResponse = (TokenResponse)((Object)result.getResult());
            jwt.setJwt(tokenResponse.getAccessToken());
            jwt.setExpire(System.currentTimeMillis() + tokenResponse.getExpiresIn() * 1000L);
            logger.info("Get client credentials token {} with expire_in {} seconds", (Object)jwt, (Object)tokenResponse.getExpiresIn());
            jwt.setScopes(tokenResponse.getScope());
            return Success.of((Object)jwt);
        }
        logger.info("Get client credentials token fail with status: {}", (Object)result.getError().toString());
        return Failure.of((Status)result.getError());
    }

    private static void setScope(TokenRequest tokenRequest, final Jwt jwt) {
        if (jwt.getKey() != null && !jwt.getKey().getScopes().isEmpty()) {
            tokenRequest.setScope((List<String>)new ArrayList<String>(){
                {
                    this.addAll(jwt.getKey().getScopes());
                }
            });
        }
    }

    public static ContentType getContentTypeFromExchange(ClientExchange exchange) {
        HeaderValues headerValues = exchange.getResponse().getResponseHeaders().get(Headers.CONTENT_TYPE);
        return headerValues == null ? ContentType.ANY_TYPE : ContentType.toContentType((String)headerValues.getFirst());
    }

    private static String escapeBasedOnType(ContentType contentType, String responseBody) {
        switch (contentType) {
            case APPLICATION_JSON: {
                try {
                    String escapedStr = Config.getInstance().getMapper().writeValueAsString((Object)responseBody);
                    return escapedStr.substring(1, escapedStr.length() - 1);
                }
                catch (JsonProcessingException e) {
                    logger.error("escape json response fails");
                    return responseBody;
                }
            }
            case XML: {
                return OauthHelper.escapeXml(responseBody);
            }
        }
        return responseBody;
    }

    private static String escapeXml(String nonEscapedXmlStr) {
        StringBuilder escapedXML = new StringBuilder();
        block7: for (int i = 0; i < nonEscapedXmlStr.length(); ++i) {
            char c = nonEscapedXmlStr.charAt(i);
            switch (c) {
                case '<': {
                    escapedXML.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        escapedXML.append("&#" + c + ";");
                        continue block7;
                    }
                    escapedXML.append(c);
                }
            }
        }
        return escapedXML.toString();
    }

    public static void adjustNoChunkedEncoding(ClientRequest request, String requestBody) {
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (transferEncodingString != null) {
            request.getRequestHeaders().remove(Headers.TRANSFER_ENCODING);
        }
        if (fixedLengthString != null && Long.parseLong(fixedLengthString) > 0L) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)requestBody)) {
            long contentLength = requestBody.getBytes(StandardCharsets.UTF_8).length;
            request.getRequestHeaders().put(Headers.CONTENT_LENGTH, contentLength);
        }
    }

    private static class TokenRequestAction
    implements Runnable {
        private ClientConnection connection;
        private AtomicReference<Result<TokenResponse>> reference;
        private CountDownLatch latch;
        private IClientRequestComposable requestComposer;
        private TokenRequest tokenRequest;

        TokenRequestAction(TokenRequest tokenRequest, IClientRequestComposable requestComposer, ClientConnection connection, AtomicReference<Result<TokenResponse>> reference, CountDownLatch latch) {
            this.tokenRequest = tokenRequest;
            this.connection = connection;
            this.reference = reference;
            this.latch = latch;
            this.requestComposer = requestComposer;
        }

        @Override
        public void run() {
            ClientRequest request = this.requestComposer.composeClientRequest(this.tokenRequest);
            final String requestBody = this.requestComposer.composeRequestBody(this.tokenRequest);
            if (logger.isDebugEnabled()) {
                logger.debug("The request sent to the oauth server = request header(s): {}, request body: {}", (Object)request.getRequestHeaders().toString(), (Object)requestBody);
            }
            OauthHelper.adjustNoChunkedEncoding(request, requestBody);
            this.connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                    result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                        public void completed(final ClientExchange result) {
                            new StringReadChannelListener(Http2Client.BUFFER_POOL){

                                protected void stringDone(String string) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("getToken response = " + string);
                                    }
                                    reference.set(OauthHelper.handleResponse(OauthHelper.getContentTypeFromExchange(result), string));
                                    latch.countDown();
                                }

                                protected void error(IOException e) {
                                    logger.error("IOException:", (Throwable)e);
                                    reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                    latch.countDown();
                                }
                            }.setup(result.getResponseChannel());
                        }

                        public void failed(IOException e) {
                            logger.error("IOException:", (Throwable)e);
                            reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                            latch.countDown();
                        }
                    });
                }

                public void failed(IOException e) {
                    logger.error("IOException:", (Throwable)e);
                    reference.set(Failure.of((Status)new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                    latch.countDown();
                }
            });
        }
    }
}

