/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.config.Config;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenKeyRequest
extends KeyRequest {
    private static Logger logger = LoggerFactory.getLogger(TokenKeyRequest.class);
    @Deprecated
    public static String TOKEN = "token";

    public TokenKeyRequest(String kid) {
        super(kid);
        Map<String, Object> clientConfig = ClientConfig.get().getMappedConfig();
        if (clientConfig != null) {
            Map oauthConfig = (Map)clientConfig.get("oauth");
            if (oauthConfig != null) {
                Map keyConfig = (Map)oauthConfig.get("key");
                if (keyConfig != null) {
                    this.setKeyOptions(keyConfig);
                    Map secret = Config.getInstance().getJsonMapConfig("secret");
                    this.setClientSecret((String)secret.get("keyClientSecret"));
                } else {
                    Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
                    if (tokenConfig != null) {
                        keyConfig = (Map)tokenConfig.get("key");
                        if (keyConfig != null) {
                            this.setKeyOptions(keyConfig);
                            this.setClientSecret((String)keyConfig.get("client_secret"));
                        } else {
                            logger.error("Error: could not find key section in token of oauth in client.yml");
                        }
                    } else {
                        logger.error("Error: could not find token section of oauth in client.yml");
                    }
                }
            } else {
                logger.error("Error: could not find oauth section in client.yml");
            }
        } else {
            logger.error("Error: could not load client.yml for Token Key");
        }
    }

    private void setKeyOptions(Map<String, Object> keyConfig) {
        this.setServerUrl((String)keyConfig.get("server_url"));
        this.setServiceId((String)keyConfig.get("serviceId"));
        Object object = keyConfig.get("enableHttp2");
        this.setEnableHttp2(object != null && (Boolean)object != false);
        this.setUri(keyConfig.get("uri") + "/" + this.kid);
        this.setClientId((String)keyConfig.get("client_id"));
    }
}

