/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.cache.ICacheStrategy;
import com.networknt.client.oauth.cache.LongestExpireCacheStrategy;
import com.networknt.config.Config;
import com.networknt.monad.Result;
import io.undertow.client.ClientRequest;
import io.undertow.util.HeaderValues;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class TokenManager {
    private Map<String, Object> clientConfig = Config.getInstance().getJsonMapConfig("client");
    @Deprecated
    public static final String CACHE = "cache";
    @Deprecated
    public static final String OAUTH = "oauth";
    @Deprecated
    public static final String TOKEN = "token";
    @Deprecated
    public static final String CAPACITY_CONFIG = "capacity";
    private static volatile TokenManager INSTANCE;
    private static int CAPACITY;
    private ICacheStrategy cacheStrategy;

    private TokenManager() {
        Map cacheConfig;
        Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null && (cacheConfig = (Map)tokenConfig.get(CACHE)) != null && cacheConfig.get(CAPACITY_CONFIG) != null) {
            CAPACITY = (Integer)cacheConfig.get(CAPACITY_CONFIG);
        }
        this.cacheStrategy = new LongestExpireCacheStrategy(CAPACITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TokenManager> clazz = TokenManager.class;
        synchronized (TokenManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Result<Jwt> getJwt(Jwt.Key key) {
        Jwt cachedJwt = this.getJwt(this.cacheStrategy, key);
        Result<Jwt> result = OauthHelper.populateCCToken(cachedJwt);
        if (result.isSuccess()) {
            this.cacheStrategy.cacheJwt(key, (Jwt)result.getResult());
        }
        return result;
    }

    private synchronized Jwt getJwt(ICacheStrategy cacheStrategy, Jwt.Key key) {
        Jwt result = cacheStrategy.getCachedJwt(key);
        if (result == null) {
            result = new Jwt(key);
            cacheStrategy.cacheJwt(key, result);
        }
        return result;
    }

    public Result<Jwt> getJwt(ClientRequest clientRequest) {
        HeaderValues scope = clientRequest.getRequestHeaders().get("scope");
        if (scope != null) {
            String scopeStr = scope.getFirst();
            HashSet<String> scopeSet = new HashSet<String>();
            scopeSet.addAll(Arrays.asList(scopeStr.split(" ")));
            return this.getJwt(new Jwt.Key(scopeSet));
        }
        HeaderValues serviceId = clientRequest.getRequestHeaders().get("serviceId");
        if (serviceId != null) {
            return this.getJwt(new Jwt.Key(serviceId.getFirst()));
        }
        return this.getJwt(new Jwt.Key());
    }

    static {
        CAPACITY = 200;
    }
}

