/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.AsyncResponse;
import com.networknt.client.AsyncResult;
import com.networknt.client.ClientConfig;
import com.networknt.client.DefaultAsyncResult;
import com.networknt.client.circuitbreaker.CircuitBreaker;
import com.networknt.client.http.Http2ClientCompletableFutureNoRequest;
import com.networknt.client.http.Http2ClientCompletableFutureWithRequest;
import com.networknt.client.http.Http2ClientConnectionPool;
import com.networknt.client.http.Light4jHttp2ClientProvider;
import com.networknt.client.http.Light4jHttpClientProvider;
import com.networknt.client.listener.ByteBufferReadChannelListener;
import com.networknt.client.listener.ByteBufferWriteChannelListener;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.TokenManager;
import com.networknt.client.ssl.ClientX509ExtendedTrustManager;
import com.networknt.client.ssl.TLSConfig;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.TlsUtil;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class Http2Client {
    private static final Logger logger = LoggerFactory.getLogger(Http2Client.class);
    public static final String CONFIG_NAME = "client";
    public static final String CONFIG_SECRET = "secret";
    public static final OptionMap DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client").getMap();
    public static XnioWorker WORKER;
    @Deprecated
    public static XnioSsl SSL;
    public static final AttachmentKey<String> RESPONSE_BODY;
    public static AttachmentKey<ByteBuffer> BUFFER_BODY;
    static final String TLS = "tls";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String TRUST_STORE = "trustStore";
    static final String KEY_STORE = "keyStore";
    static final String KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    static final String KEY_STORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private TokenManager tokenManager = TokenManager.getInstance();
    private Http2ClientConnectionPool http2ClientConnectionPool = Http2ClientConnectionPool.getInstance();
    public static final ByteBufferPool BUFFER_POOL;
    @Deprecated
    public static final ByteBufferPool POOL;
    @Deprecated
    public static final ByteBufferPool SSL_BUFFER_POOL;
    protected final Map<String, ClientProvider> clientProviders;
    private static final Http2Client INSTANCE;

    protected Http2Client() {
        this(Http2Client.class.getClassLoader());
    }

    private Http2Client(ClassLoader classLoader) {
        ServiceLoader<ClientProvider> providers = ServiceLoader.load(ClientProvider.class, classLoader);
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                this.addProvider(map, scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
        try {
            Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
            WORKER = xnio.createWorker(null, DEFAULT_OPTIONS);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    private void addProvider(Map<String, ClientProvider> map, String scheme, ClientProvider provider) {
        if (System.getProperty("java.version").startsWith("1.8.")) {
            if ("https".equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttpClientProvider());
            } else if ("h2".equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttp2ClientProvider());
            } else {
                map.put(scheme, provider);
            }
        } else {
            map.put(scheme, provider);
        }
    }

    public XnioSsl createXnioSsl(SSLContext sslContext) {
        return new UndertowXnioSsl(WORKER.getXnio(), OptionMap.EMPTY, BUFFER_POOL, sslContext);
    }

    public static ClientConnection safeConnect(long timeoutSeconds, IoFuture<ClientConnection> future) {
        if (future.await(timeoutSeconds, TimeUnit.SECONDS) != IoFuture.Status.DONE) {
            throw new RuntimeException("Connection establishment timed out");
        }
        ClientConnection connection = null;
        try {
            connection = (ClientConnection)future.get();
        }
        catch (IOException e) {
            throw new RuntimeException("Connection establishment generated I/O exception", e);
        }
        if (connection == null) {
            throw new RuntimeException("Connection establishment failed (null) - Full connection terminated");
        }
        return connection;
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, worker, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(bindAddress, uri, worker, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public XnioSsl getDefaultXnioSsl() {
        if (SSL == null) {
            try {
                SSL = this.createXnioSsl(Http2Client.createSSLContext());
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return SSL;
    }

    public void returnConnection(ClientConnection connection) {
        this.http2ClientConnectionPool.resetConnectionStatus(connection);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            logger.info("Got an open connection from http2ClientConnectionPool");
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        logger.info("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, worker, ssl, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, final URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect((ClientCallback)new ClientCallback<ClientConnection>(){

            public void completed(ClientConnection r) {
                logger.debug("Adding the new connection: {} to FutureResult and cache it for uri: {}", (Object)r, (Object)uri);
                result.setResult((Object)r);
                Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
            }

            public void failed(IOException e) {
                logger.debug("Failed to get new connection for uri: {}", (Object)uri);
                result.setException(e);
            }
        }, bindAddress, uri, worker, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, ioThread, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(bindAddress, uri, ioThread, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult result = new FutureResult();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            result.setResult((Object)connection);
            return result.getIoFuture();
        }
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    public ClientConnection safeBorrowConnection(long timeoutSeconds, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, ioThread, ssl, bufferPool, options);
        return Http2Client.safeConnect(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect((ClientCallback)new ClientCallback<ClientConnection>(){

            public void completed(ClientConnection r) {
                logger.debug("Adding the new connection: {} to FutureResult and cache it for uri: {}", (Object)r, (Object)uri);
                result.setResult((Object)r);
                Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
            }

            public void failed(IOException e) {
                logger.debug("Failed to get new connection for uri: {}", (Object)uri);
                result.setException(e);
            }
        }, bindAddress, uri, ioThread, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        return this.clientProviders.get(uri.getScheme());
    }

    public static Http2Client getInstance() {
        return INSTANCE;
    }

    public static Http2Client getInstance(ClassLoader classLoader) {
        return new Http2Client(classLoader);
    }

    public void addAuthToken(ClientRequest request, String token) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
    }

    public void addAuthTokenTrace(ClientRequest request, String token, String traceabilityId) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
    }

    public Result addCcToken(ClientRequest request) {
        Result<Jwt> result = this.tokenManager.getJwt(request);
        if (result.isFailure()) {
            return Failure.of((Status)result.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + ((Jwt)result.getResult()).getJwt());
        return result;
    }

    public Result addCcTokenTrace(ClientRequest request, String traceabilityId) {
        Result<Jwt> result = this.tokenManager.getJwt(request);
        if (result.isFailure()) {
            return Failure.of((Status)result.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + ((Jwt)result.getResult()).getJwt());
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
        return result;
    }

    public Result propagateHeaders(ClientRequest request, HttpServerExchange exchange) {
        String tid = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
        String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String cid = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID);
        return this.populateHeader(request, token, cid, tid);
    }

    public Result populateHeader(ClientRequest request, String authToken, String correlationId, String traceabilityId) {
        if (traceabilityId != null) {
            this.addAuthTokenTrace(request, authToken, traceabilityId);
        } else {
            this.addAuthToken(request, authToken);
        }
        Result<Jwt> result = this.tokenManager.getJwt(request);
        if (result.isFailure()) {
            return Failure.of((Status)result.getError());
        }
        request.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, correlationId);
        request.getRequestHeaders().put(HttpStringConstants.SCOPE_TOKEN, "Bearer " + ((Jwt)result.getResult()).getJwt());
        return result;
    }

    public static SSLContext createSSLContext() throws IOException {
        Map tlsMap = (Map)ClientConfig.get().getMappedConfig().get(TLS);
        return null == tlsMap ? null : Http2Client.createSSLContext((String)tlsMap.get("defaultGroupKey"));
    }

    public static SSLContext createSSLContext(String trustedNamesGroupKey) throws IOException {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        Map tlsMap = (Map)ClientConfig.get().getMappedConfig().get(TLS);
        if (tlsMap != null) {
            try {
                Boolean loadKeyStore = (Boolean)tlsMap.get(LOAD_KEY_STORE);
                if (loadKeyStore != null && loadKeyStore.booleanValue()) {
                    String keyStoreName = System.getProperty(KEY_STORE_PROPERTY);
                    String keyStorePass = System.getProperty(KEY_STORE_PASSWORD_PROPERTY);
                    if (keyStoreName != null && keyStorePass != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from system property at " + Encode.forJava((String)keyStoreName));
                        }
                    } else {
                        keyStoreName = (String)tlsMap.get(KEY_STORE);
                        keyStorePass = (String)ClientConfig.get().getSecretConfig().get("clientKeystorePass");
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from config at " + Encode.forJava((String)keyStoreName));
                        }
                    }
                    if (keyStoreName != null && keyStorePass != null) {
                        String keyPass = (String)ClientConfig.get().getSecretConfig().get("clientKeyPass");
                        KeyStore keyStore = TlsUtil.loadKeyStore((String)keyStoreName, (char[])keyStorePass.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        keyManagerFactory.init(keyStore, keyPass.toCharArray());
                        keyManagers = keyManagerFactory.getKeyManagers();
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException("Unable to initialise KeyManager[]", e);
            }
            TrustManager[] trustManagers = null;
            try {
                Boolean loadTrustStore = (Boolean)tlsMap.get(LOAD_TRUST_STORE);
                if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                    String trustStoreName = System.getProperty(TRUST_STORE_PROPERTY);
                    String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
                    if (trustStoreName != null && trustStorePass != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading trust store from system property at " + Encode.forJava((String)trustStoreName));
                        }
                    } else {
                        trustStoreName = (String)tlsMap.get(TRUST_STORE);
                        trustStorePass = (String)ClientConfig.get().getSecretConfig().get("clientTruststorePass");
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading trust store from config at " + Encode.forJava((String)trustStoreName));
                        }
                    }
                    if (trustStoreName != null && trustStorePass != null) {
                        KeyStore trustStore = TlsUtil.loadTrustStore((String)trustStoreName, (char[])trustStorePass.toCharArray());
                        TLSConfig tlsConfig = TLSConfig.create(tlsMap, trustedNamesGroupKey);
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(trustStore);
                        trustManagers = ClientX509ExtendedTrustManager.decorate(trustManagerFactory.getTrustManagers(), tlsConfig);
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to initialise TrustManager[]", e);
            }
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to create and initialise the SSLContext", e);
            }
        }
        logger.error("TLS configuration section is missing in client.yml");
        return sslContext;
    }

    public static String getFormDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8").replaceAll("\\+", "%20"));
        }
        return result.toString();
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                logger.error("IOException:", (Throwable)e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        logger.error("IOException:", (Throwable)e);
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", (Throwable)e);
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                logger.error("IOException:", (Throwable)e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> byteBufferClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new ByteBufferReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void bufferDone(List<Byte> out) {
                                byte[] byteArray = new byte[out.size()];
                                int index = 0;
                                for (byte b : out) {
                                    byteArray[index++] = b;
                                }
                                result.getResponse().putAttachment(BUFFER_BODY, (Object)ByteBuffer.wrap(byteArray));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)null, (ChannelExceptionHandler)null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException var3) {
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> byteBufferClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final ByteBuffer requestBody) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                new ByteBufferWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new ByteBufferReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void bufferDone(List<Byte> out) {
                                byte[] byteArray = new byte[out.size()];
                                int index = 0;
                                for (byte b : out) {
                                    byteArray[index++] = b;
                                }
                                result.getResponse().putAttachment(BUFFER_BODY, (Object)ByteBuffer.wrap(byteArray));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)null, (ChannelExceptionHandler)null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException var3) {
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final String requestBody) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(BUFFER_POOL){

                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                logger.error("IOException:", (Throwable)e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        logger.error("IOException:", (Throwable)e);
                        latch.countDown();
                    }
                });
            }

            public void failed(IOException e) {
                logger.error("IOException:", (Throwable)e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                logger.error("IOException:", (Throwable)e);
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        logger.error("IOException:", (Throwable)e);
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", (Throwable)e);
                    reference.set(DefaultAsyncResult.fail(e));
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                logger.error("IOException:", (Throwable)e);
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch, final String requestBody) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(BUFFER_POOL){

                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                logger.error("IOException:", (Throwable)e);
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        logger.error("IOException:", (Throwable)e);
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
            }

            public void failed(IOException e) {
                logger.error("IOException:", (Throwable)e);
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public CircuitBreaker getRequestService(URI uri, ClientRequest request, Optional<String> requestBody) {
        return new CircuitBreaker(() -> this.callService(uri, request, requestBody));
    }

    public CompletableFuture<ClientResponse> callService(URI uri, ClientRequest request, Optional<String> requestBody) {
        CompletableFuture<ClientResponse> futureClientResponse;
        this.addHostHeader(request);
        AtomicReference<ClientConnection> currentConnection = new AtomicReference<ClientConnection>(this.http2ClientConnectionPool.getConnection(uri));
        if (currentConnection.get() != null && currentConnection.get().isOpen()) {
            logger.debug("Reusing the connection: {} to {}", (Object)currentConnection.toString(), (Object)uri.toString());
            futureClientResponse = this.getFutureClientResponse(currentConnection.get(), uri, request, requestBody);
        } else {
            CompletableFuture<ClientConnection> futureConnection = this.connectAsync(uri);
            futureClientResponse = futureConnection.thenComposeAsync(clientConnection -> {
                currentConnection.set((ClientConnection)clientConnection);
                return this.getFutureClientResponse((ClientConnection)clientConnection, uri, request, requestBody);
            });
        }
        futureClientResponse.thenAcceptAsync(clientResponse -> this.http2ClientConnectionPool.resetConnectionStatus((ClientConnection)currentConnection.get()));
        return futureClientResponse;
    }

    public CompletableFuture<ClientResponse> callService(String protocol, String serviceId, String envTag, ClientRequest request, Optional<String> requestBody) {
        try {
            Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
            String url = cluster.serviceToUrl(protocol, serviceId, envTag, null);
            if (url == null) {
                logger.error("Failed to discover service with serviceID: {}, and tag: {}", (Object)serviceId, (Object)envTag);
                throw new ClientException(String.format("Failed to discover service with serviceID: %s, and tag: %s", serviceId, envTag));
            }
            return this.callService(new URI(url), request, requestBody);
        }
        catch (Exception e) {
            logger.error("Failed to call service: {}", (Object)serviceId);
            throw new RuntimeException("Failed to call service: " + serviceId, e);
        }
    }

    public CompletableFuture<ClientConnection> connectAsync(URI uri) {
        if ("https".equals(uri.getScheme()) && SSL == null) {
            SSL = this.getDefaultXnioSsl();
        }
        return this.connectAsync(null, uri, WORKER, SSL, BUFFER_POOL, ClientConfig.get().getRequestEnableHttp2() ? OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true) : OptionMap.EMPTY);
    }

    public CompletableFuture<ClientConnection> connectAsync(InetSocketAddress bindAddress, final URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if ("https".equals(uri.getScheme()) && SSL == null) {
            SSL = this.getDefaultXnioSsl();
        }
        final CompletableFuture<ClientConnection> completableFuture = new CompletableFuture<ClientConnection>();
        ClientProvider provider = this.clientProviders.get(uri.getScheme());
        try {
            provider.connect((ClientCallback)new ClientCallback<ClientConnection>(){

                public void completed(ClientConnection r) {
                    completableFuture.complete(r);
                    Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
                }

                public void failed(IOException e) {
                    completableFuture.completeExceptionally(e);
                }
            }, bindAddress, uri, worker, ssl, bufferPool, options);
        }
        catch (Throwable t) {
            completableFuture.completeExceptionally(t);
        }
        return completableFuture;
    }

    private CompletableFuture<ClientResponse> getFutureClientResponse(ClientConnection clientConnection, URI uri, ClientRequest request, Optional<String> requestBody) {
        if (requestBody.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("The request sent to {} = request header: {}, request body: {}", new Object[]{uri.toString(), request.getRequestHeaders().toString(), requestBody.get()});
            }
            Http2ClientCompletableFutureWithRequest futureClientResponseWithRequest = new Http2ClientCompletableFutureWithRequest(requestBody.get());
            try {
                clientConnection.sendRequest(request, (ClientCallback)futureClientResponseWithRequest);
            }
            catch (Exception e) {
                futureClientResponseWithRequest.completeExceptionally(e);
            }
            return futureClientResponseWithRequest;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The request sent to {} = request header: {}, request body is empty", (Object)uri.toString(), (Object)request.getRequestHeaders().toString());
        }
        Http2ClientCompletableFutureNoRequest futureClientResponseNoRequest = new Http2ClientCompletableFutureNoRequest();
        try {
            clientConnection.sendRequest(request, (ClientCallback)futureClientResponseNoRequest);
        }
        catch (Exception e) {
            futureClientResponseNoRequest.completeExceptionally(e);
        }
        return futureClientResponseNoRequest;
    }

    private void addHostHeader(ClientRequest request) {
        if (!request.getRequestHeaders().contains(Headers.HOST)) {
            request.getRequestHeaders().put(Headers.HOST, "localhost");
        }
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        BUFFER_BODY = AttachmentKey.create(ByteBuffer.class);
        ArrayList masks = new ArrayList();
        ModuleRegistry.registerModule((String)Http2Client.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
        POOL = BUFFER_POOL = new DefaultByteBufferPool(true, ClientConfig.get().getBufferSize() * 1024);
        SSL_BUFFER_POOL = BUFFER_POOL;
        INSTANCE = new Http2Client();
    }
}

