/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.db;

import com.networknt.config.Config;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.sql.DataSource;

public class GenericDataSource {
    protected static final String DATASOURCE = "datasource";
    protected static final String SECRET = "secret";
    private static final String DB_PASSWORD = "password";
    private static final String DS_NAME = "H2DataSource";
    private HikariDataSource ds;
    protected String dsName;

    public String getDsName() {
        return this.dsName;
    }

    public String getDbPassKey() {
        return DB_PASSWORD;
    }

    public GenericDataSource() {
        this.dsName = DS_NAME;
        this.ds = this.createDataSource();
    }

    public GenericDataSource(String dsName) {
        this.dsName = dsName;
        this.ds = this.createDataSource();
    }

    protected HikariDataSource createDataSource() {
        Map dataSourceMap = Config.getInstance().getJsonMapConfig(DATASOURCE);
        Map secret = Config.getInstance().getJsonMapConfig(SECRET);
        Map mainParams = (Map)dataSourceMap.get(this.getDsName());
        Map configParams = (Map)mainParams.get("parameters");
        this.ds = new HikariDataSource();
        this.ds.setJdbcUrl((String)mainParams.get("jdbcUrl"));
        this.ds.setUsername((String)mainParams.get("username"));
        String password = (String)mainParams.get(DB_PASSWORD);
        if (password == null) {
            password = (String)secret.get(this.getDbPassKey());
        }
        this.ds.setPassword(password);
        this.ds.setMaximumPoolSize(((Integer)mainParams.get("maximumPoolSize")).intValue());
        this.ds.setConnectionTimeout((long)((Integer)mainParams.get("connectionTimeout")).intValue());
        if (configParams != null) {
            configParams.forEach((k, v) -> this.ds.addDataSourceProperty(k, v));
        }
        return this.ds;
    }

    public DataSource getDataSource() {
        return this.ds;
    }
}

