/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.deref;

import com.networknt.client.oauth.DerefRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.config.Config;
import com.networknt.deref.DerefConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerefMiddlewareHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(DerefMiddlewareHandler.class);
    private static final String CONFIG_NAME = "deref";
    private static final String MISSING_AUTH_TOKEN = "ERR10002";
    private static final String EMPTY_TOKEN_DEREFERENCE_RESPONSE = "ERR10044";
    private static final String TOKEN_DEREFERENCE_ERROR = "ERR10045";
    public static DerefConfig config = (DerefConfig)Config.getInstance().getJsonObjectConfig("deref", DerefConfig.class);
    private volatile HttpHandler next;

    public DerefMiddlewareHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("DerefMiddlewareHandler is constructed.");
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        if (token == null) {
            this.setExchangeStatus(exchange, MISSING_AUTH_TOKEN, new Object[0]);
            return;
        }
        if (token.indexOf(46) < 0) {
            DerefRequest request = new DerefRequest(token);
            String response = OauthHelper.derefToken((DerefRequest)request);
            if (response == null || response.trim().length() == 0) {
                this.setExchangeStatus(exchange, EMPTY_TOKEN_DEREFERENCE_RESPONSE, new Object[]{token});
                return;
            }
            if (response.startsWith("{")) {
                this.setExchangeStatus(exchange, TOKEN_DEREFERENCE_ERROR, new Object[]{response});
                return;
            }
            exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + response);
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)DerefMiddlewareHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

