/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.config.ConfigException;
import com.networknt.router.RouterConfig;
import java.net.URI;
import java.util.List;

public class HostWhitelist {
    private RouterConfig config = RouterConfig.load();

    public boolean isHostAllowed(URI serviceUri) {
        if (serviceUri != null) {
            List<String> hostWhitelist = this.config.getHostWhitelist();
            if (hostWhitelist == null || hostWhitelist.size() == 0) {
                throw new ConfigException("No whitelist defined to allow the route to " + serviceUri);
            }
            String host = serviceUri.getHost();
            return hostWhitelist.stream().anyMatch(hostRegEx -> host != null && host.matches((String)hostRegEx));
        }
        return false;
    }
}

