/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthServerConfig {
    private static final Logger logger = LoggerFactory.getLogger(OAuthServerConfig.class);
    public static final String CONFIG_NAME = "oauthServer";
    private static final String ENABLED = "enabled";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String PASS_THROUGH = "passThrough";
    private static final String TOKEN_SERVICE_ID = "tokenServiceId";
    private Map<String, Object> mappedConfig;
    private Config config = Config.getInstance();
    private boolean enabled;
    private boolean passThrough;
    private String tokenServiceId;
    List<String> clientCredentials;

    private OAuthServerConfig() {
        this(CONFIG_NAME);
    }

    private OAuthServerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public static OAuthServerConfig load() {
        return new OAuthServerConfig();
    }

    public static OAuthServerConfig load(String configName) {
        return new OAuthServerConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getClientCredentials() {
        return this.clientCredentials;
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }

    public String getTokenServiceId() {
        return this.tokenServiceId;
    }

    public void setTokenServiceId(String tokenServiceId) {
        this.tokenServiceId = tokenServiceId;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.enabled = true;
        }
        if ((object = this.mappedConfig.get(PASS_THROUGH)) != null && ((Boolean)object).booleanValue()) {
            this.passThrough = true;
        }
        this.tokenServiceId = (String)this.getMappedConfig().get(TOKEN_SERVICE_ID);
    }

    private void setConfigList() {
        if (this.mappedConfig.get(CLIENT_CREDENTIALS) != null) {
            Object object = this.mappedConfig.get(CLIENT_CREDENTIALS);
            this.clientCredentials = new ArrayList<String>();
            if (object instanceof String) {
                String s = (String)object;
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("[")) {
                    try {
                        this.clientCredentials = (List)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the clientCredentials json with a list of strings.");
                    }
                } else {
                    this.clientCredentials = Arrays.asList(s.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.clientCredentials.add((String)item));
            } else {
                throw new ConfigException("clientCredentials must be a string or a list of strings.");
            }
        }
    }
}

