/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.client.oauth.Jwt;
import com.networknt.config.JsonMapper;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.router.OAuthServerConfig;
import com.networknt.router.middleware.TokenHandler;
import com.networknt.utility.HashUtil;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthServerHandler
implements LightHttpHandler {
    static final Logger logger = LoggerFactory.getLogger(OAuthServerHandler.class);
    private static final String UNSUPPORTED_GRANT_TYPE = "ERR12001";
    private static final String INVALID_BASIC_CREDENTIALS = "ERR12004";
    private static final String CONTENT_TYPE_MISSING = "ERR10076";
    private static final String INVALID_CONTENT_TYPE = "ERR10077";
    private static final String MISSING_AUTHORIZATION_HEADER = "ERR12002";
    private static final String INVALID_AUTHORIZATION_HEADER = "ERR12003";
    OAuthServerConfig config = OAuthServerConfig.load();

    public OAuthServerHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("OAuthServerHandler is loaded.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            logger.error("content type is missing and it is required.");
            this.setExchangeStatus(exchange, CONTENT_TYPE_MISSING, new Object[0]);
            return;
        }
        if (!(contentType.startsWith("application/json") || contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded"))) {
            logger.error("invalid content type " + contentType);
            this.setExchangeStatus(exchange, INVALID_CONTENT_TYPE, new Object[]{contentType});
            return;
        }
        Map formMap = (Map)exchange.getAttachment(AttachmentConstants.REQUEST_BODY);
        String clientId = (String)formMap.get("client_id");
        String clientSecret = (String)formMap.get("client_secret");
        String grantType = (String)formMap.get("grant_type");
        if (!"client_credentials".equals(grantType)) {
            logger.error("not supported grant type " + grantType);
            this.setExchangeStatus(exchange, UNSUPPORTED_GRANT_TYPE, new Object[]{grantType});
            return;
        }
        Object credentials = null;
        if (clientId != null && clientSecret != null) {
            credentials = clientId + ":" + clientSecret;
        } else {
            String auth = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (auth == null) {
                logger.error("Missing authorization header.");
                this.setExchangeStatus(exchange, MISSING_AUTHORIZATION_HEADER, new Object[0]);
                return;
            }
            if (!"BASIC".equalsIgnoreCase(auth.substring(0, 5))) {
                logger.error("Invalid authorization header " + auth.substring(0, 10));
                this.setExchangeStatus(exchange, INVALID_AUTHORIZATION_HEADER, new Object[]{auth.substring(0, 10)});
                return;
            }
            credentials = auth.substring(6);
            int pos = ((String)credentials).indexOf(58);
            if (pos == -1) {
                credentials = new String(Base64.decodeBase64((String)credentials), StandardCharsets.UTF_8);
            }
        }
        if (this.config.getClientCredentials() != null) {
            if (this.config.getClientCredentials().stream().anyMatch(((String)credentials)::equals)) {
                HashMap<String, Object> resMap = new HashMap<String, Object>();
                if (this.config.isPassThrough()) {
                    Result<Jwt> result = TokenHandler.getJwtToken(this.config.getTokenServiceId());
                    if (result.isFailure()) {
                        logger.error("Cannot populate or renew jwt for client credential grant type: " + result.getError().toString());
                        this.setExchangeStatus(exchange, result.getError());
                        return;
                    }
                    Jwt jwt = (Jwt)result.getResult();
                    resMap.put("access_token", jwt.getJwt());
                    resMap.put("token_type", "bearer");
                    resMap.put("expires_in", (jwt.getExpire() - System.currentTimeMillis()) / 1000L);
                } else {
                    resMap.put("access_token", HashUtil.generateUUID());
                    resMap.put("token_type", "bearer");
                    resMap.put("expires_in", 600);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("matched credential, sending response.");
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                exchange.getResponseSender().send(JsonMapper.toJson(resMap));
                return;
            }
        }
        logger.error("invalid credentials");
        this.setExchangeStatus(exchange, INVALID_BASIC_CREDENTIALS, new Object[]{credentials});
    }
}

