/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.handler.config.MethodRewriteRule;
import com.networknt.handler.config.QueryHeaderRewriteRule;
import com.networknt.handler.config.UrlRewriteRule;
import com.networknt.utility.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterConfig {
    private static final Logger logger = LoggerFactory.getLogger(RouterConfig.class);
    static final String CONFIG_NAME = "router";
    private static final String HTTP2_ENABLED = "http2Enabled";
    private static final String HTTPS_ENABLED = "httpsEnabled";
    private static final String REWRITE_HOST_HEADER = "rewriteHostHeader";
    private static final String REUSE_X_FORWARDED = "reuseXForwarded";
    private static final String MAX_REQUEST_TIME = "maxRequestTime";
    private static final String PATH_PREFIX_MAX_REQUEST_TIME = "pathPrefixMaxRequestTime";
    private static final String CONNECTION_PER_THREAD = "connectionsPerThread";
    private static final String SOFT_MAX_CONNECTIONS_PER_THREAD = "softMaxConnectionsPerThread";
    private static final String MAX_CONNECTION_RETRIES = "maxConnectionRetries";
    private static final String MAX_QUEUE_SIZE = "maxQueueSize";
    private static final String SERVICE_ID_QUERY_PARAMETER = "serviceIdQueryParameter";
    private static final String PRE_RESOLVE_FQDN_2_IP = "preResolveFQDN2IP";
    private static final String METRICS_INJECTION = "metricsInjection";
    private static final String METRICS_NAME = "metricsName";
    boolean http2Enabled;
    boolean httpsEnabled;
    int maxRequestTime;
    Map<String, Integer> pathPrefixMaxRequestTime;
    int connectionsPerThread;
    int softMaxConnectionsPerThread;
    boolean rewriteHostHeader;
    boolean reuseXForwarded;
    int maxConnectionRetries;
    int maxQueueSize;
    boolean preResolveFQDN2IP;
    boolean metricsInjection;
    String metricsName;
    List<String> hostWhitelist;
    List<UrlRewriteRule> urlRewriteRules;
    List<MethodRewriteRule> methodRewriteRules;
    Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules;
    Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules;
    Set httpMethods = new HashSet();
    private Config config;
    private Map<String, Object> mappedConfig;
    boolean serviceIdQueryParameter;

    private RouterConfig() {
        this(CONFIG_NAME);
    }

    private RouterConfig(String configName) {
        this.httpMethods.add("GET");
        this.httpMethods.add("POST");
        this.httpMethods.add("DELETE");
        this.httpMethods.add("PUT");
        this.httpMethods.add("PATCH");
        this.config = Config.getInstance();
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setHostWhitelist();
        this.setUrlRewriteRules();
        this.setMethodRewriteRules();
        this.setQueryParamRewriteRules();
        this.setHeaderRewriteRules();
        this.setPathPrefixMaxRequestTime();
    }

    public static RouterConfig load() {
        return new RouterConfig();
    }

    public static RouterConfig load(String configName) {
        return new RouterConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setHostWhitelist();
        this.setUrlRewriteRules();
        this.setMethodRewriteRules();
        this.setQueryParamRewriteRules();
        this.setHeaderRewriteRules();
        this.setPathPrefixMaxRequestTime();
    }

    public void setConfigData() {
        Object object = this.getMappedConfig().get(HTTP2_ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.http2Enabled = true;
        }
        if ((object = this.getMappedConfig().get(HTTPS_ENABLED)) != null && ((Boolean)object).booleanValue()) {
            this.httpsEnabled = true;
        }
        if ((object = this.getMappedConfig().get(REWRITE_HOST_HEADER)) != null && ((Boolean)object).booleanValue()) {
            this.rewriteHostHeader = true;
        }
        if ((object = this.getMappedConfig().get(REUSE_X_FORWARDED)) != null && ((Boolean)object).booleanValue()) {
            this.reuseXForwarded = true;
        }
        if ((object = this.getMappedConfig().get(MAX_REQUEST_TIME)) != null) {
            this.maxRequestTime = (Integer)object;
        }
        if ((object = this.getMappedConfig().get(CONNECTION_PER_THREAD)) != null) {
            this.connectionsPerThread = (Integer)object;
        }
        if ((object = this.getMappedConfig().get(SOFT_MAX_CONNECTIONS_PER_THREAD)) != null) {
            this.softMaxConnectionsPerThread = (Integer)object;
        }
        if ((object = this.getMappedConfig().get(MAX_CONNECTION_RETRIES)) != null) {
            this.maxConnectionRetries = (Integer)object;
        }
        if ((object = this.getMappedConfig().get(MAX_QUEUE_SIZE)) != null) {
            this.maxQueueSize = (Integer)object;
        }
        if ((object = this.getMappedConfig().get(SERVICE_ID_QUERY_PARAMETER)) != null) {
            this.serviceIdQueryParameter = (Boolean)object;
        }
        if ((object = this.getMappedConfig().get(PRE_RESOLVE_FQDN_2_IP)) != null && ((Boolean)object).booleanValue()) {
            this.preResolveFQDN2IP = true;
        }
        if ((object = this.getMappedConfig().get(METRICS_INJECTION)) != null && ((Boolean)object).booleanValue()) {
            this.metricsInjection = true;
        }
        if ((object = this.getMappedConfig().get(METRICS_NAME)) != null) {
            this.metricsName = (String)object;
        }
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public int getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public Map<String, Integer> getPathPrefixMaxRequestTime() {
        return this.pathPrefixMaxRequestTime;
    }

    public int getConnectionsPerThread() {
        return this.connectionsPerThread;
    }

    public int getSoftMaxConnectionsPerThread() {
        return this.softMaxConnectionsPerThread;
    }

    public boolean isRewriteHostHeader() {
        return this.rewriteHostHeader;
    }

    public boolean isReuseXForwarded() {
        return this.reuseXForwarded;
    }

    public boolean isPreResolveFQDN2IP() {
        return this.preResolveFQDN2IP;
    }

    public boolean isMetricsInjection() {
        return this.metricsInjection;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public int getMaxConnectionRetries() {
        return this.maxConnectionRetries;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public List<String> getHostWhitelist() {
        return this.hostWhitelist;
    }

    public void setHostWhitelist() {
        this.hostWhitelist = new ArrayList<String>();
        if (this.mappedConfig.get("hostWhitelist") != null && this.mappedConfig.get("hostWhitelist") instanceof String) {
            this.hostWhitelist.add((String)this.mappedConfig.get("hostWhitelist"));
        } else {
            this.hostWhitelist = (List)this.mappedConfig.get("hostWhitelist");
        }
    }

    public void setHostWhitelist(List<String> hostWhitelist) {
        this.hostWhitelist = hostWhitelist;
    }

    public List<UrlRewriteRule> getUrlRewriteRules() {
        return this.urlRewriteRules;
    }

    public void setUrlRewriteRules() {
        this.urlRewriteRules = new ArrayList<UrlRewriteRule>();
        if (this.mappedConfig.get("urlRewriteRules") != null && this.mappedConfig.get("urlRewriteRules") instanceof String) {
            this.urlRewriteRules.add(UrlRewriteRule.convertToUrlRewriteRule((String)((String)this.mappedConfig.get("urlRewriteRules"))));
        } else {
            List rules = (List)this.mappedConfig.get("urlRewriteRules");
            if (rules != null) {
                for (String s : rules) {
                    this.urlRewriteRules.add(UrlRewriteRule.convertToUrlRewriteRule((String)s));
                }
            }
        }
    }

    public void setUrlRewriteRules(List<UrlRewriteRule> urlRewriteRules) {
        this.urlRewriteRules = urlRewriteRules;
    }

    public List<MethodRewriteRule> getMethodRewriteRules() {
        return this.methodRewriteRules;
    }

    public void setMethodRewriteRules() {
        this.methodRewriteRules = new ArrayList<MethodRewriteRule>();
        if (this.mappedConfig.get("methodRewriteRules") != null && this.mappedConfig.get("methodRewriteRules") instanceof String) {
            this.methodRewriteRules.add(this.convertToMethodRewriteRule((String)this.mappedConfig.get("methodRewriteRules")));
        } else {
            List rules = (List)this.mappedConfig.get("methodRewriteRules");
            if (rules != null) {
                for (String s : rules) {
                    this.methodRewriteRules.add(this.convertToMethodRewriteRule(s));
                }
            }
        }
    }

    private MethodRewriteRule convertToMethodRewriteRule(String s) {
        String[] parts = StringUtils.split((String)s, (char)' ');
        if (parts.length != 3) {
            String error = "The Method rewrite rule " + s + " must have three parts";
            logger.error(error);
            throw new ConfigException(error);
        }
        String sourceMethod = parts[1].trim().toUpperCase();
        if (!this.httpMethods.contains(sourceMethod)) {
            String error = "The source method converted to uppercase " + sourceMethod + " is not a valid HTTP Method";
            logger.error(error);
            throw new ConfigException(error);
        }
        String targetMethod = parts[2].trim().toUpperCase();
        if (!this.httpMethods.contains(targetMethod)) {
            String error = "The target method converted to uppercase " + targetMethod + " is not a valid HTTP Method";
            logger.error(error);
            throw new ConfigException(error);
        }
        return new MethodRewriteRule(parts[0], sourceMethod, targetMethod);
    }

    public void setMethodRewriteRules(List<MethodRewriteRule> methodRewriteRules) {
        this.methodRewriteRules = methodRewriteRules;
    }

    public boolean isServiceIdQueryParameter() {
        return this.serviceIdQueryParameter;
    }

    public void setServiceIdQueryParameter(boolean serviceIdQueryParameter) {
        this.serviceIdQueryParameter = serviceIdQueryParameter;
    }

    public Map<String, List<QueryHeaderRewriteRule>> getQueryParamRewriteRules() {
        return this.queryParamRewriteRules;
    }

    public void setQueryParamRewriteRules(Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules) {
        this.queryParamRewriteRules = queryParamRewriteRules;
    }

    public void setQueryParamRewriteRules() {
        this.queryParamRewriteRules = new HashMap<String, List<QueryHeaderRewriteRule>>();
        if (this.mappedConfig.get("queryParamRewriteRules") != null && this.mappedConfig.get("queryParamRewriteRules") instanceof Map) {
            Map map = (Map)this.mappedConfig.get("queryParamRewriteRules");
            for (Map.Entry r : map.entrySet()) {
                String key = (String)r.getKey();
                Object object = r.getValue();
                if (!(object instanceof List)) continue;
                ArrayList<QueryHeaderRewriteRule> rules = new ArrayList<QueryHeaderRewriteRule>();
                List values = (List)object;
                for (Map value : values) {
                    QueryHeaderRewriteRule rule = new QueryHeaderRewriteRule();
                    rule.setOldK((String)value.get("oldK"));
                    rule.setNewK((String)value.get("newK"));
                    rule.setOldV((String)value.get("oldV"));
                    rule.setNewV((String)value.get("newV"));
                    rules.add(rule);
                }
                this.queryParamRewriteRules.put(key, rules);
            }
        }
    }

    public Map<String, List<QueryHeaderRewriteRule>> getHeaderRewriteRules() {
        return this.headerRewriteRules;
    }

    public void setHeaderRewriteRules(Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules) {
        this.headerRewriteRules = headerRewriteRules;
    }

    public void setHeaderRewriteRules() {
        this.headerRewriteRules = new HashMap<String, List<QueryHeaderRewriteRule>>();
        if (this.mappedConfig.get("headerRewriteRules") != null && this.mappedConfig.get("headerRewriteRules") instanceof Map) {
            Map map = (Map)this.mappedConfig.get("headerRewriteRules");
            for (Map.Entry r : map.entrySet()) {
                String key = (String)r.getKey();
                Object object = r.getValue();
                if (!(object instanceof List)) continue;
                ArrayList<QueryHeaderRewriteRule> rules = new ArrayList<QueryHeaderRewriteRule>();
                List values = (List)object;
                for (Map value : values) {
                    QueryHeaderRewriteRule rule = new QueryHeaderRewriteRule();
                    rule.setOldK((String)value.get("oldK"));
                    rule.setNewK((String)value.get("newK"));
                    rule.setOldV((String)value.get("oldV"));
                    rule.setNewV((String)value.get("newV"));
                    rules.add(rule);
                }
                this.headerRewriteRules.put(key, rules);
            }
        }
    }

    public void setPathPrefixMaxRequestTime() {
        this.pathPrefixMaxRequestTime = new HashMap<String, Integer>();
        if (this.mappedConfig.get(PATH_PREFIX_MAX_REQUEST_TIME) != null) {
            if (this.mappedConfig.get(PATH_PREFIX_MAX_REQUEST_TIME) instanceof Map) {
                this.pathPrefixMaxRequestTime = (Map)this.mappedConfig.get(PATH_PREFIX_MAX_REQUEST_TIME);
            } else if (this.mappedConfig.get(PATH_PREFIX_MAX_REQUEST_TIME) instanceof String) {
                String s = (String)this.mappedConfig.get(PATH_PREFIX_MAX_REQUEST_TIME);
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("{")) {
                    try {
                        this.pathPrefixMaxRequestTime = (Map)Config.getInstance().getMapper().readValue(s, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", (Throwable)e);
                    }
                } else {
                    LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                    for (String keyValue : s.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        map.put(pairs[0], pairs.length == 1 ? this.maxRequestTime : Integer.valueOf(pairs[1]));
                    }
                    this.pathPrefixMaxRequestTime = map;
                }
            } else {
                logger.error("pathPrefixMaxRequestTime is the wrong type. Only JSON map or YAML map is supported.");
            }
        }
    }
}

