/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router;

import com.networknt.client.Http2Client;
import com.networknt.handler.Handler;
import com.networknt.handler.ProxyHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.AbstractMetricsHandler;
import com.networknt.router.RouterConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingRouterProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;

public class RouterHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RouterHandler.class);
    private static RouterConfig config;
    protected static ProxyHandler proxyHandler;
    protected static AbstractMetricsHandler metricsHandler;

    public RouterHandler() {
        Map handlers;
        config = RouterConfig.load();
        ModuleRegistry.registerModule((String)RouterHandler.class.getName(), config.getMappedConfig(), null);
        LoadBalancingRouterProxyClient client = new LoadBalancingRouterProxyClient();
        if (RouterHandler.config.httpsEnabled) {
            client.setSsl(Http2Client.getInstance().getDefaultXnioSsl());
        }
        if (RouterHandler.config.http2Enabled) {
            client.setOptionMap(OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
        } else {
            client.setOptionMap(OptionMap.EMPTY);
        }
        proxyHandler = ProxyHandler.builder().setProxyClient((ProxyClient)client).setMaxConnectionRetries(RouterHandler.config.maxConnectionRetries).setMaxQueueSize(RouterHandler.config.maxQueueSize).setMaxRequestTime(RouterHandler.config.maxRequestTime).setPathPrefixMaxRequestTime(RouterHandler.config.pathPrefixMaxRequestTime).setReuseXForwarded(RouterHandler.config.reuseXForwarded).setRewriteHostHeader(RouterHandler.config.rewriteHostHeader).setUrlRewriteRules(RouterHandler.config.urlRewriteRules).setMethodRewriteRules(RouterHandler.config.methodRewriteRules).setQueryParamRewriteRules(RouterHandler.config.queryParamRewriteRules).setHeaderRewriteRules(RouterHandler.config.headerRewriteRules).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).build();
        if (config.isMetricsInjection() && (metricsHandler = (AbstractMetricsHandler)(handlers = Handler.getHandlers()).get("metrics")) == null) {
            logger.error("An instance of MetricsHandler is not configured in the handler.yml.");
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("RouterHandler.handleRequest starts.");
        }
        if (metricsHandler != null) {
            exchange.putAttachment(AttachmentConstants.METRICS_HANDLER, (Object)metricsHandler);
            exchange.putAttachment(AttachmentConstants.DOWNSTREAM_METRICS_NAME, (Object)config.getMetricsName());
            exchange.putAttachment(AttachmentConstants.DOWNSTREAM_METRICS_START, (Object)System.nanoTime());
        }
        proxyHandler.handleRequest(exchange);
        if (logger.isDebugEnabled()) {
            logger.debug("RouterHandler.handleRequest ends.");
        }
    }

    public void reload() {
        Map handlers;
        config.reload();
        ModuleRegistry.registerModule((String)RouterHandler.class.getName(), config.getMappedConfig(), null);
        LoadBalancingRouterProxyClient client = new LoadBalancingRouterProxyClient();
        if (RouterHandler.config.httpsEnabled) {
            client.setSsl(Http2Client.getInstance().getDefaultXnioSsl());
        }
        if (RouterHandler.config.http2Enabled) {
            client.setOptionMap(OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
        } else {
            client.setOptionMap(OptionMap.EMPTY);
        }
        proxyHandler = ProxyHandler.builder().setProxyClient((ProxyClient)client).setMaxConnectionRetries(RouterHandler.config.maxConnectionRetries).setMaxQueueSize(RouterHandler.config.maxQueueSize).setMaxRequestTime(RouterHandler.config.maxRequestTime).setPathPrefixMaxRequestTime(RouterHandler.config.pathPrefixMaxRequestTime).setReuseXForwarded(RouterHandler.config.reuseXForwarded).setRewriteHostHeader(RouterHandler.config.rewriteHostHeader).setUrlRewriteRules(RouterHandler.config.urlRewriteRules).setMethodRewriteRules(RouterHandler.config.methodRewriteRules).setQueryParamRewriteRules(RouterHandler.config.queryParamRewriteRules).setHeaderRewriteRules(RouterHandler.config.headerRewriteRules).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).build();
        if (config.isMetricsInjection() && (metricsHandler = (AbstractMetricsHandler)(handlers = Handler.getHandlers()).get("metrics")) == null) {
            logger.error("An instance of MetricsHandler is not configured in the handler.yml.");
        }
    }
}

