/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.HandlerUtils;
import com.networknt.router.middleware.PathPrefixServiceConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPrefixServiceHandler
implements MiddlewareHandler {
    static Logger logger = LoggerFactory.getLogger(PathPrefixServiceHandler.class);
    protected volatile HttpHandler next;
    protected static PathPrefixServiceConfig config;

    public PathPrefixServiceHandler() {
        logger.info("PathServiceHandler is constructed");
        config = PathPrefixServiceConfig.load();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("PathPrefixServiceHandler.handleRequest starts.");
        }
        this.pathPrefixService(exchange);
        if (logger.isDebugEnabled()) {
            logger.debug("PathPrefixServiceHandler.handleRequest ends.");
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    protected void pathPrefixService(HttpServerExchange exchange) throws Exception {
        HashMap<String, CallSite> auditInfo;
        String serviceId;
        String requestPath = exchange.getRequestURI();
        String[] serviceEntry = HandlerUtils.findServiceEntry(HandlerUtils.normalisePath(requestPath), config.getMapping());
        HeaderValues serviceIdHeader = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID);
        String string = serviceId = serviceIdHeader != null ? serviceIdHeader.peekFirst() : null;
        if (serviceId == null && serviceEntry != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("serviceEntry found and header is set for service_id = " + serviceEntry[1]);
            }
            exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceEntry[1]);
        }
        if ((auditInfo = (HashMap<String, CallSite>)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
            auditInfo = new HashMap<String, CallSite>();
            if (serviceEntry != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is null and serviceEntry found and endpoint is set to = " + serviceEntry[0] + "@" + exchange.getRequestMethod().toString().toLowerCase());
                }
                auditInfo.put("endpoint", (CallSite)((Object)(serviceEntry[0] + "@" + exchange.getRequestMethod().toString().toLowerCase())));
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is null and serviceEntry is null and endpoint is set to = unknown@" + exchange.getRequestMethod().toString().toLowerCase());
                }
                auditInfo.put("endpoint", (CallSite)((Object)("unknown@" + exchange.getRequestMethod().toString().toLowerCase())));
            }
            exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        } else if (!auditInfo.containsKey("endpoint")) {
            if (serviceEntry != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is not null and does not contain endpoint, serviceEntry found set endpoint to = " + serviceEntry[0] + "@" + exchange.getRequestMethod().toString().toLowerCase());
                }
                auditInfo.put("endpoint", (CallSite)((Object)(serviceEntry[0] + "@" + exchange.getRequestMethod().toString().toLowerCase())));
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is not null and does not contain endpoint, serviceEntry is null and endpoint is set to = unknown@" + exchange.getRequestMethod().toString().toLowerCase());
                }
                auditInfo.put("endpoint", (CallSite)((Object)("unknown@" + exchange.getRequestMethod().toString().toLowerCase())));
            }
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)PathPrefixServiceHandler.class.getName(), config.getMappedConfig(), null);
    }

    public void reload() {
        config.reload();
        ModuleRegistry.registerModule((String)PathPrefixServiceHandler.class.getName(), config.getMappedConfig(), null);
    }
}

